<?php

namespace Modules\EmailConfig\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\EmailConfig\Models\EmailConfig;

class EmailConfigDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks!
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        /*
         * EmailConfigs Seed
         * ------------------
         */

        // DB::table('emailconfigs')->truncate();
        // echo "Truncate: emailconfigs \n";

        EmailConfig::factory()->count(20)->create();
        $rows = EmailConfig::all();
        echo " Insert: emailconfigs \n\n";

        // Enable foreign key checks!
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
