<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Queue;

class ProcessEmailQueue extends Command
{
    protected $signature = 'email:process-queue';
    protected $description = 'Process queued emails';    public function handle()
    {
        $this->info('Processing email queue...');
        
        // Process jobs in the email queue using artisan queue:work
        $this->call('queue:work', [
            '--queue' => 'emails',
            '--sleep' => 3,
            '--tries' => 3,
            '--max-time' => 3600,
            '--once' => true // Process one job and exit
        ]);

        $this->info('Email queue processing completed.');
    }
}
