<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class PackageController extends Controller
{
    public function index()
    {
        $packages = Package::latest()->paginate(10);
        return view('admin.pages.packages.index', compact('packages'));
    }

    public function create()
    {
        return view('admin.pages.packages.create');
    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'           => 'required|string|max:100',
           
            'description'    => 'nullable|string',
            'package_price'  => 'required|numeric|min:0',
            'duration'       => 'required|in:day,week,month,year,unlimited',
            'status'         => 'required|in:active,disable',
            'verified_badge' => 'nullable|boolean',
            'edit_post'      => 'nullable|boolean',
            'business_page'  => 'nullable|boolean',
            'space_limit'    => 'required|integer|min:0|max:255',
            'product_limit'  => 'required|integer|min:0|max:255',
            'withdraw_limit' => 'required|numeric|min:0',
            'job_limit'      => 'required|integer|min:0|max:255',
            'course_limit'   => 'required|integer|min:0|max:255',
            'event_limit'    => 'required|integer|min:0|max:255',
        ]);
    
        // Ensure checkboxes (switches) save as 0/1
        $validated['verified_badge'] = $request->has('verified_badge') ? 1 : 0;
        $validated['edit_post']      = $request->has('edit_post') ? 1 : 0;
        $validated['business_page']  = $request->has('business_page') ? 1 : 0;
    
        Package::create($validated);
    
        Session::flash('success', 'Package created successfully!');
        return redirect()->route('admin.packages.index');
    }

    public function show(Package $package)
    {
        return view('admin.pages.packages.show', compact('package'));
    }

    public function edit(Package $package)
    {
        return view('admin.pages.packages.edit', compact('package'));
    }

    public function update(Request $request, Package $package)
    {
        $validated = $request->validate([
            'name'           => 'required|string|max:100',
            'description'    => 'nullable|string',
            'package_price'  => 'required|numeric|min:0',
            'duration'       => 'required|in:day,week,month,year,unlimited',
            'status'         => 'required|in:active,disable',
            'withdraw_limit' => 'required|numeric|min:0',
            'event_limit'    => 'required|integer|min:0|max:255',
            'space_limit'    => 'required|integer|min:0|max:255',
            'product_limit'  => 'required|integer|min:0|max:255',
            'job_limit'      => 'required|integer|min:0|max:255',
            'course_limit'   => 'required|integer|min:0|max:255',
        ]);
        $validated['verified_badge'] = $request->has('verified_badge') ? 1 : 0;
        $validated['edit_post']      = $request->has('edit_post') ? 1 : 0;
        $validated['business_page']  = $request->has('business_page') ? 1 : 0;
        $package->update($validated);
        Session::flash('success', 'Package updated successfully!');
        return redirect()->route('admin.packages.index');
    }

    public function destroy(Package $package)
    {
        $package->delete();
        Session::flash('success', 'Package deleted successfully!');
        return redirect()->route('admin.packages.index');
    }
}
