<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WithdrawRequest;

class WithdrawRequestController extends Controller
{
    public function index()
    {
        $withdrawRequests = WithdrawRequest::with('user')
            ->orderBy('created_at', 'desc')
            ->paginate(15);

        return view('admin.pages.withdraw-requests.index', compact('withdrawRequests'));
    }

    public function show($id)
    {
        $withdrawRequest = WithdrawRequest::with('user')
            ->findOrFail($id);

        return view('admin.pages.withdraw-requests.show', compact('withdrawRequest'));
    }

    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|in:2,3', // 2 for Approve, 3 for Reject
        ]);

        $withdrawRequest = WithdrawRequest::findOrFail($id);
        $withdrawRequest->status = $request->status;
        $withdrawRequest->save();

        $statusText = $request->status == 2 ? 'approved' : 'rejected';
        
        return redirect()->route('admin.withdraw-requests.show', $id)
            ->with('success', "Withdraw request has been {$statusText} successfully.");
    }
}