<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Permission;
class PermissionController extends Controller
{
    public function index()
    {
        $data['page_title'] = 'All Permissions';
        $data['permissions'] = Permission::all();
        return view('admin.pages.permissions.index',$data);
    }

    public function store(Request $request)
    {
        $validate = $request->validate([
            'name'=>'required|unique:roles'
        ]);
        $name = $request->input('name');
        $res = Permission::create(['name'=>$name]);
        if($res)
        {
            session()->flash('message', 'Permission Created Successfully');
            return back();
        }
    }
    public function edit($id)
    {
        $data['page_title'] = 'Edit Role';
        $data['role'] = Permission::find($id);
        return view('admin.pages.permissions.edit',$data);
    }
    public function update($id,Request $request)
    {
        $validate = $request->validate([
            'name'=>['required',Rule::unique('roles', 'name')->ignore($id)]
        ]);
        $name = $request->input('name');
        $res = Permission::where('id',$id)->update(['name'=>$name]);
        if($res)
        {
            session()->flash('message', 'Permission Updated Successfully');
            return redirect()->route('admin.permissions.index');
        }
    }
    // public function delete($id)
    // {


    //     $res = Role::where('id',$id)->delete();
    //     if($res)
    //     {
    //         session()->flash('message', 'Role deleted Successfully');
    //         return redirect()->route('admin.permissions.index');
    //     }
    // }


}
