<?php
namespace App\Http\Resources\BloodBank;

use App\Http\Resources\UserShortResource;
use Illuminate\Http\Resources\Json\JsonResource;

class BloodRequestResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'user' => new UserShortResource($this->whenLoaded('user')),
            'blood_type' => $this->blood_type,
            'units_needed' => $this->units_needed,
            'units_fulfilled' => $this->units_fulfilled,
            'hospital_id' => $this->hospital_id,
            'hospital_name' => $this->hospital_name,
            'hospital_address' => $this->hospital_address,
            'contact_phone' => $this->contact_phone,
            'reason' => $this->reason,
            'urgency' => $this->urgency,
            'urgency_label' => $this->getUrgencyLabel(),
            'status' => $this->status,
            'needed_by' => $this->needed_by ? $this->needed_by->format('Y-m-d') : null,
            'is_public' => (bool) $this->is_public,
            'distance' => $this->when(isset($this->distance), function () {
                return round($this->distance, 1);
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'donations' => BloodDonationResource::collection($this->whenLoaded('donations')),
        ];
    }
    
    private function getUrgencyLabel()
    {
        return match($this->urgency) {
            'emergency' => 'Emergency',
            'urgent' => 'Urgent',
            default => 'Normal'
        };
    }
}
