<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FundingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'donatin_title' => $this->donation_title,
            'donation_image' => getMedia($this->donation_image,'avatar'),
            'amount' => $this->amount,
            'description' => $this->description,
        ];
    }
}
