<?php

namespace App\Http\Resources;

use App\Models\GroupMember;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class GroupResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'user_id' => $this->user_id,
            'description' => $this->description,
            'privacy' => $this->privacy,
            'type' => $this->privacy, // For backward compatibility
            'cover_image' => getMedia($this->cover_image, 'cover'),
            'is_private' => (bool) $this->is_private,
            'allow_members_to_post' => (bool) $this->allow_members_to_post,
            'members_count' => $this->members()->count(),
            'is_group_owner' => (Auth::id() == $this->user_id) ? true : false,
            'already_member' => GroupMember::where(['user_id' => Auth::id(), 'group_id' => $this->id, 'role' => 'member'])->exists(),
            'slug' => $this->slug,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'category_id' => $this->category_id,
            'is_featured' => (bool) $this->is_featured,
            'active' => (bool) $this->active,
        ];
    }
}
