<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LivestreamResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'agora_channel_name' => $this->agora_channel_name,
            'agora_token' => $this->agora_token,
            'status' => $this->status,
            'creator' => new UserShortResource($this->creator),
        ];
    }
}
