<?php

namespace App\Http\Resources\Messenger;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MessageAttachmentResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'file_name' => $this->file_name,
            'file_size' => $this->file_size,
            'formatted_size' => $this->formatted_size,
            'mime_type' => $this->mime_type,
            'url' => $this->url,
            'thumbnail_url' => $this->thumbnail_url,
            'metadata' => $this->when($this->metadata, $this->metadata),
            'created_at' => $this->created_at?->toISOString(),
        ];
    }
}
