<?php

namespace App\Models\BloodBank;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BloodBank extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'address',
        'phone',
        'email',
        'description'
    ];

    public function inventory()
    {
        return $this->hasMany(BloodInventory::class);
    }

    public function donations()
    {
        return $this->hasMany(BloodDonation::class);
    }

    public function bloodDrives()
    {
        return $this->hasMany(BloodDrive::class);
    }
}