<?php


namespace App\Models\BloodBank;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DriveRegistration extends Model
{
    use HasFactory;
    protected $table = 'blood_drive_registrations';
    protected $fillable = [
        'blood_drive_id',
        'user_id',
        'name',
        'phone',
        'email',
        'blood_type',
        'status'
    ];

    public function bloodDrive()
    {
        return $this->belongsTo(BloodDrive::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}