<?php

namespace App\Models\Courses;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class CourseQuestion extends Model
{
    protected $fillable = [
        'user_id', 'course_id', 'lesson_id', 'question', 'is_resolved'
    ];

    protected $casts = [
        'is_resolved' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function lesson()
    {
        return $this->belongsTo(CourseLesson::class);
    }

    public function answers()
    {
        return $this->hasMany(CourseAnswer::class, 'question_id');
    }

    public function bestAnswer()
    {
        return $this->answers()->where('is_best_answer', true)->first();
    }

    public function markAsResolved()
    {
        $this->is_resolved = true;
        $this->save();
    }
}
