<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Deposit extends Model
{
    protected $table = 'deposits';

    protected $fillable = [
        'user_id',
        'withdraw_method_id',
        'transaction_id',
        'amount',
        'currency',
        'charge',
        'rate',
        'final_amo',
        'detail',
        'btc_amo',
        'btc_wallet',
        'trx',
        'deposit_status',
        'admin_feedback'
    ];

    /**
     * Get the user that owns the deposit.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}