<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Job extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'job_title',
        'job_description',
        'job_location',
        'category_id',
        'minimum_salary',
        'maximum_salary',
        'currency',
        'salary_date',
        'experience_years',
        'company_name',
        'job_type',
        'expiry_date',
        'is_urgent_hiring',
        // New fields
        'company_website',
        'company_logo',
        'work_location_type',
        'city',
        'state',
        'country',
        'key_responsibilities',
        'requirements',
        'positions_available',
        'education_level',
        'application_method',
        'application_email',
        'application_url',
        'required_documents',
        'benefits',
        'skills',
        'languages',
        'screening_questions',
        'is_featured',
        'hide_company',
        'salary_display',
        'status'
    ];

    protected $casts = [
        'key_responsibilities' => 'array',
        'requirements' => 'array',
        'required_documents' => 'array',
        'benefits' => 'array',
        'skills' => 'array',
        'languages' => 'array',
        'screening_questions' => 'array',
        'is_urgent_hiring' => 'boolean',
        'is_featured' => 'boolean',
        'hide_company' => 'boolean',
        'expiry_date' => 'date',
        'salary_date' => 'date'
    ];

    // Existing relationships remain the same
    public function category()
    {
        return $this->belongsTo(JobCategory::class);
    }

    public function applications()
    {
        return $this->hasMany(JobApplication::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function similarJobs()
    {
        return $this->hasMany(Job::class, 'category_id', 'category_id');
    }
    public function deleteJob($job)
    {
        JobApplication::where('job_id', $job)->delete();
        SavedJob::where('job_id', $job)->delete();
        $this->where('id', $job)->delete();
    }
}
