<?php

namespace App\Models\Marketplace;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'product_id',
        'store_id',
        'buyer_id',
        'seller_id',
        'quantity',
        'price',
        'status',
        'options',
        'commission_amount',
        'is_reviewed'
    ];

    protected $casts = [
        'price' => 'float',
        'commission_amount' => 'float',
        'options' => 'json',
        'is_reviewed' => 'boolean'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function store()
    {
        return $this->belongsTo(Store::class);
    }

    public function buyer()
    {
        return $this->belongsTo(User::class, 'buyer_id');
    }

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id');
    }

    public function review()
    {
        return $this->hasOne(ProductReview::class, 'product_id', 'product_id')
                   ->where('user_id', $this->buyer_id);
    }

    // Calculate total price for this order item
    public function getTotalAttribute()
    {
        return $this->price * $this->quantity;
    }
}
