<?php

namespace App\Models\Marketplace;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'icon',
    ];

    /**
     * Get the products associated with this category.
     */
    public function products()
    {
        return $this->hasMany(Product::class, 'category_id'); // Ensure this references category_id
    }
}
