<?php

namespace App\Models\Marketplace;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductReview extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'order_id',
        'user_id',
        'store_id',
        'rating',
        'comment',
        'status', // pending, approved, rejected
        'is_recommended',
        'images',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'rating' => 'float',
        'is_recommended' => 'boolean',
        'images' => 'json'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function store()
    {
        return $this->belongsTo(Store::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    // Scopes
    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }

    // Get reviews with high ratings (4-5)
    public function scopePositive($query)
    {
        return $query->where('rating', '>=', 4);
    }

    // Get reviews with medium ratings (3)
    public function scopeNeutral($query)
    {
        return $query->where('rating', 3);
    }

    // Get reviews with low ratings (1-2)
    public function scopeNegative($query)
    {
        return $query->where('rating', '<', 3);
    }
}