<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RewardSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'action_type',
        'reward_amount',
        'daily_limit',
        'monthly_limit',
        'is_active',
        'description',
        'conditions'
    ];

    protected $casts = [
        'conditions' => 'array',
    ];

    /**
     * Get the reward amount for a specific action.
     *
     * @param string $actionType
     * @return float|null
     */
    public static function getRewardAmount($actionType)
    {
        $setting = self::where('action_type', $actionType)
            ->where('is_active', true)
            ->first();

        return $setting ? $setting->reward_amount : null;
    }

    /**
     * Check if an action is eligible for a reward.
     *
     * @param string $actionType
     * @return bool
     */
    public static function isActionRewardable($actionType)
    {
        return self::where('action_type', $actionType)
            ->where('is_active', true)
            ->exists();
    }
} 