<?php

namespace App\Models;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Space extends Model
{
    use HasFactory,SoftDeletes;
    public function getSpaces($allspaces,$user_id)
    {
        $spaces = [];
        foreach ($allspaces as  $space) {
            $spaces[] = $this->getsingleSpace($space,$user_id);
        }
        return $spaces;
    }
    
    public function getsingleSpace($space,$user_id)
    {
       
        $space->is_mine = ($user_id==$space->user_id)?1:0;
        $space->speaker_count = SpaceMember::where(['space_id'=>$space->id,'is_cohost'=>1,'is_host'=>0])->count();
        
        $spacecheckInModel = New SpaceCheckIn();
        $space->is_joined  = $spacecheckInModel->checkedIn($user_id,$space->id);
        return $space;

    }
 

    public function userdata(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }

    public function members(){
        return $this->hasMany(SpaceMember::class, 'space_id');
    }
 
}
