<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Story extends Model
{
    protected $fillable = [
        'user_id',
        'description',
        'type',
        'media',
        'thumbnail',
        'duration',
        'expire_at',
        'created_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function seenUsers()
    {
        return $this->belongsToMany(User::class, 'stories_seen')
            ->withTimestamps();
    }
}
