<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WithdrawRequest extends Model
{
    protected $table = 'withdraw_requests';

    protected $fillable = [
        'user_id',
        'type',
        'full_name',
        'paypal_email',
        'iban',
        'country',
        'bank_name',
        'bank_account_no',
        'swift_code',
        'amount',
        'status',
        'address',
        'deduction'
    ];

    /**
     * Get the user that owns the withdraw request.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}