<?php

use App\Http\Middleware\SetLocale;
use App\Http\Middleware\CheckModuleStatus;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // $middleware->web(SetLocale::class);
        $middleware->web(append: [
            SetLocale::class,
        ]);
        
        // Register route middleware aliases
        $middleware->alias([
            'moduleStatus' => CheckModuleStatus::class,
            'admin' => \App\Http\Middleware\CheckAdminRole::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
