<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Media Storage Driver
    |--------------------------------------------------------------------------
    |
    | This option controls the default storage driver used for media files.
    | You can override this per call using the storageDriver parameter.
    |
    */

    'default_driver' => env('MEDIA_STORAGE_DRIVER', config('filesystems.default', 'local')),

    /*
    |--------------------------------------------------------------------------
    | Media Storage Drivers
    |--------------------------------------------------------------------------
    |
    | Here you may configure the storage drivers for different types of media.
    | Each driver can have its own configuration and fallback options.
    |
    */

    'drivers' => [
        'local' => [
            'disk' => 'local',
            'fallback_drivers' => ['public', 'media'],
            'base_path' => 'uploads',
            'url_prefix' => null,
        ],
        
        'public' => [
            'disk' => 'public',
            'fallback_drivers' => ['local', 'media'],
            'base_path' => 'uploads',
            'url_prefix' => '/storage',
            'url' => '/storage',
        ],
        
        's3' => [
            'disk' => 's3',
            'fallback_drivers' => ['public', 'local'],
            'base_path' => 'uploads',
            'url_prefix' => null,
            'cloudfront_domain' => env('AWS_CLOUDFRONT_DOMAIN'),
            'cdn_enabled' => env('AWS_CDN_ENABLED', false),
        ],
        
        'media' => [
            'disk' => 'media',
            'fallback_drivers' => ['public', 'local'],
            'base_path' => 'uploads',
            'url_prefix' => '/storage/media',
            'url' => '/storage/media',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Media Types Configuration
    |--------------------------------------------------------------------------
    |
    | Configure specific settings for different media types.
    |
    */

    'types' => [
        'avatar' => [
            'max_size' => 2048, // KB
            'allowed_extensions' => ['jpg', 'jpeg', 'png', 'gif'],
            'dimensions' => [
                'max_width' => 500,
                'max_height' => 500,
            ],
            'path' => 'avatars',
            'preferred_driver' => 'public',
        ],
        
        'cover' => [
            'max_size' => 5120, // KB
            'allowed_extensions' => ['jpg', 'jpeg', 'png'],
            'dimensions' => [
                'max_width' => 1920,
                'max_height' => 1080,
            ],
            'path' => 'covers',
            'preferred_driver' => 'public',
        ],
        
        'image' => [
            'max_size' => 10240, // KB
            'allowed_extensions' => ['jpg', 'jpeg', 'png', 'gif', 'webp'],
            'dimensions' => [
                'max_width' => 4096,
                'max_height' => 4096,
            ],
            'path' => 'images',
            'preferred_driver' => null,
        ],
        
        'video' => [
            'max_size' => 102400, // KB
            'allowed_extensions' => ['mp4', 'avi', 'mov', 'wmv', 'flv'],
            'path' => 'videos',
            'preferred_driver' => 'public',
        ],
        
        'document' => [
            'max_size' => 51200, // KB
            'allowed_extensions' => ['pdf', 'doc', 'docx', 'txt', 'rtf'],
            'path' => 'documents',
            'preferred_driver' => 'public',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Placeholder Images
    |--------------------------------------------------------------------------
    |
    | Configure placeholder images for different media types.
    |
    */

    'placeholders' => [
        'avatar' => 'assets/placeholder/user.png',
        'cover' => 'assets/placeholder/cover.png',
        'image' => 'assets/placeholder/image.png',
        'video' => 'assets/placeholder/video.png',
        'document' => 'assets/placeholder/document.png',
    ],

    /*
    |--------------------------------------------------------------------------
    | Image Processing
    |--------------------------------------------------------------------------
    |
    | Configure image processing options like resizing, compression, etc.
    |
    */

    'image_processing' => [
        'enabled' => env('MEDIA_IMAGE_PROCESSING', true),
        'quality' => env('MEDIA_IMAGE_QUALITY', 85),
        'resize_large_images' => env('MEDIA_RESIZE_LARGE_IMAGES', true),
        'create_thumbnails' => env('MEDIA_CREATE_THUMBNAILS', true),
        'thumbnail_sizes' => [ 'small' => [350, 350]],
        // 'thumbnail_sizes' => [
        //     'small' => [150, 150],
        //     'medium' => [300, 300],
        //     'large' => [600, 600],
        // ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Settings
    |--------------------------------------------------------------------------
    |
    | Configure security-related settings for media uploads.
    |
    */

    'security' => [
        'scan_uploads' => env('MEDIA_SCAN_UPLOADS', false),
        'allowed_mime_types' => [
            'image/jpeg',
            'image/png',
            'image/gif',
            'image/webp',
            'video/mp4',
            'video/avi',
            'video/mov',
            'application/pdf',
            'application/msword',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'text/plain',
        ],
        'blocked_extensions' => [
            'php', 'php3', 'php4', 'php5', 'phtml', 'pl', 'py', 'jsp', 'asp', 'sh', 'cgi',
        ],
    ],

]; 