<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['dm', 'group'])->default('dm');
            $table->string('title')->nullable(); // For group chats
            $table->text('description')->nullable();
            $table->string('avatar')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('last_message_id')->nullable();
            $table->timestamp('last_activity_at')->useCurrent();
            $table->json('settings')->nullable(); // Store group settings
            $table->boolean('is_archived')->default(false);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            
            $table->index(['type', 'last_activity_at']);
            $table->index(['created_by', 'last_activity_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('conversations');
    }
};
