<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('color', 20);
            $table->text('description')->nullable();
            $table->double('package_price');
            $table->enum('duration', ['day', 'week', 'month', 'year', 'unlimited']);
            $table->enum('status', ['active', 'disable']);
            $table->boolean('verified_badge')->comment('1=>Yes, 0=>No');
            $table->boolean('edit_post')->default(false)->comment('1=>Yes 0=> No');
            $table->boolean('business_page')->default(false);
            $table->tinyInteger('space_limit');
            $table->tinyInteger('product_limit');
            $table->double('withdraw_limit')->default(0);
            $table->tinyInteger('job_limit');
            $table->tinyInteger('course_limit');
            $table->tinyInteger('event_limit');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
