<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blacklist', function (Blueprint $table) {
            $table->id();

            // Optional foreign key to users table
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');

            // Blacklisted value and its type (email, ip, username, domain)
            $table->string('value')->nullable()->index();
            $table->string('type')->index(); // Enum-like behavior: email, ip, username, email_domain

            // Optional notes
            $table->text('notes')->nullable();

            $table->timestamps();

            // Ensure uniqueness to avoid duplicate entries
            $table->unique(['value', 'type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blacklist');
    }
};
