<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            if (!Schema::hasColumn('posts', 'text_color')) {
                $table->string('text_color', 20)->nullable()->after('background_color');
            }
            if (!Schema::hasColumn('posts', 'font_size')) {
                $table->string('font_size', 20)->nullable()->after('text_color');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            if (Schema::hasColumn('posts', 'font_size')) {
                $table->dropColumn('font_size');
            }
            if (Schema::hasColumn('posts', 'text_color')) {
                $table->dropColumn('text_color');
            }
        });
    }
};


