<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RewardSettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('reward_settings')->insert([
            [
                'reward_name' => 'Sign Up Bonus',
                'reward_points' => 100,
                'reward_description' => 'Points awarded for signing up.',
                'is_active' => true,
            ],
            [
                'reward_name' => 'Referral Bonus',
                'reward_points' => 50,
                'reward_description' => 'Points awarded for referring a friend.',
                'is_active' => true,
            ],
            [
                'reward_name' => 'Daily Login Bonus',
                'reward_points' => 10,
                'reward_description' => 'Points awarded for daily login.',
                'is_active' => true,
            ],
            [
                'reward_name' => 'First Purchase Bonus',
                'reward_points' => 200,
                'reward_description' => 'Points awarded for making the first purchase.',
                'is_active' => true,
            ],
            [
                'reward_name' => 'Birthday Bonus',
                'reward_points' => 30,
                'reward_description' => 'Points awarded on the user\'s birthday.',
                'is_active' => true,
            ],
        ]);
    }
} 