@extends('admin.layouts.home')

@section('title', 'Course Enrollments')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Enrollments for: {{ $course->title }}</h4>
                    <a href="{{ route('admin.courses.show', $course->id) }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Back to Course
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Student</th>
                                    <th>Email</th>
                                    <th>Price Paid</th>
                                    <th>Payment Method</th>
                                    <th>Transaction ID</th>
                                    <th>Enrolled Date</th>
                                    <th>Completed</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($enrollments as $enrollment)
                                    <tr>
                                        <td>{{ $enrollment->id }}</td>
                                        <td>{{ $enrollment->user->name ?? 'N/A' }}</td>
                                        <td>{{ $enrollment->user->email ?? 'N/A' }}</td>
                                        <td>${{ number_format($enrollment->price_paid ?? 0, 2) }}</td>
                                        <td>{{ $enrollment->payment_method ?? 'N/A' }}</td>
                                        <td>{{ $enrollment->transaction_id ?? 'N/A' }}</td>
                                        <td>{{ $enrollment->created_at->format('M d, Y') }}</td>
                                        <td>
                                            @if($enrollment->completed_at)
                                                <span class="badge bg-success">Completed</span>
                                                <br><small>{{ $enrollment->completed_at->format('M d, Y') }}</small>
                                            @else
                                                <span class="badge bg-secondary">In Progress</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No enrollments found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $enrollments->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

