@extends('admin.layouts.home')

@section('title', 'Course Details')

@php
    use Illuminate\Support\Facades\Storage;
@endphp

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Course Details</h4>
                    <div>
                        <a href="{{ route('admin.courses.enrollments', $course->id) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-users"></i> View Enrollments
                        </a>
                        <a href="{{ route('admin.courses.edit', $course->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> Edit Course
                        </a>
                        <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="course-header mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                @if($course->thumbnail)
                                    <img src="{{ Storage::url($course->thumbnail) }}" alt="{{ $course->title }}" class="img-fluid rounded">
                                @else
                                    <div class="bg-secondary text-white d-flex align-items-center justify-content-center rounded" style="height: 200px;">
                                        <i class="fas fa-image fa-3x"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="col-md-9">
                                <h3>{{ $course->title }}</h3>
                                <p class="text-muted">{{ $course->category->name ?? 'N/A' }}</p>
                                <div class="d-flex flex-wrap gap-2 mb-3">
                                    <span class="badge bg-{{ $course->is_published ? 'success' : 'secondary' }}">
                                        {{ $course->is_published ? 'Published' : 'Draft' }}
                                    </span>
                                    @if($course->is_featured)
                                        <span class="badge bg-warning"><i class="fas fa-star"></i> Featured</span>
                                    @endif
                                    <span class="badge bg-info">{{ ucfirst($course->level) }}</span>
                                    <span class="badge bg-secondary">{{ $course->language }}</span>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <strong>Price:</strong>
                                        @if($course->price == 0)
                                            <span class="badge bg-success">Free</span>
                                        @else
                                            ${{ number_format($course->price, 2) }}
                                            @if($course->discount_price)
                                                <br><small class="text-danger">${{ number_format($course->discount_price, 2) }}</small>
                                            @endif
                                        @endif
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Students:</strong> {{ $course->total_students ?? 0 }}
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Lessons:</strong> {{ $course->total_lessons ?? 0 }}
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Rating:</strong>
                                        @if($course->average_rating)
                                            {{ number_format($course->average_rating, 1) }} <i class="fas fa-star text-warning"></i>
                                            ({{ $course->total_reviews ?? 0 }} reviews)
                                        @else
                                            No ratings yet
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Course Information</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <tr>
                                            <th>Instructor:</th>
                                            <td>{{ $course->instructor->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Category:</th>
                                            <td>{{ $course->category->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Level:</th>
                                            <td>{{ ucfirst($course->level) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Language:</th>
                                            <td>{{ $course->language }}</td>
                                        </tr>
                                        <tr>
                                            <th>Created On:</th>
                                            <td>{{ $course->created_at->format('M d, Y') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Last Updated:</th>
                                            <td>{{ $course->updated_at->format('M d, Y') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Course Statistics</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <tr>
                                            <th>Total Students:</th>
                                            <td>{{ $course->total_students ?? 0 }}</td>
                                        </tr>
                                        <tr>
                                            <th>Total Lessons:</th>
                                            <td>{{ $course->total_lessons ?? 0 }}</td>
                                        </tr>
                                        <tr>
                                            <th>Total Duration:</th>
                                            <td>{{ $course->total_duration ?? 0 }} minutes</td>
                                        </tr>
                                        <tr>
                                            <th>Total Reviews:</th>
                                            <td>{{ $course->total_reviews ?? 0 }}</td>
                                        </tr>
                                        <tr>
                                            <th>Average Rating:</th>
                                            <td>
                                                @if($course->average_rating)
                                                    {{ number_format($course->average_rating, 1) }} <i class="fas fa-star text-warning"></i>
                                                @else
                                                    No ratings yet
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Enrollments:</th>
                                            <td>{{ $enrollments->total() }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Course Description</h5>
                                </div>
                                <div class="card-body">
                                    {!! nl2br(e($course->description)) !!}
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($course->requirements)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Requirements</h5>
                                </div>
                                <div class="card-body">
                                    {!! nl2br(e($course->requirements)) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($course->what_you_will_learn)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">What You Will Learn</h5>
                                </div>
                                <div class="card-body">
                                    {!! nl2br(e($course->what_you_will_learn)) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($course->target_audience)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Target Audience</h5>
                                </div>
                                <div class="card-body">
                                    {!! nl2br(e($course->target_audience)) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($course->preview_video)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Preview Video</h5>
                                </div>
                                <div class="card-body">
                                    <a href="{{ $course->preview_video }}" target="_blank" class="btn btn-primary">
                                        <i class="fas fa-video"></i> Watch Preview Video
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

