@extends('admin.layouts.home')

@section('title', 'View Custom Page')

@section('content')
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">{{ $customPage->title }}</h1>
            <div>
                <a href="{{ route('admin.custom-pages.edit', $customPage) }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm mr-2">
                    <i class="fas fa-edit fa-sm text-white-50"></i> Edit
                </a>
                <a href="{{ route('admin.custom-pages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                    <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Pages
                </a>
            </div>
        </div>

        <!-- Content Row -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Page Content</h6>
                    </div>
                    <div class="card-body">
                        <div class="content-preview">
                            {!! $customPage->content !!}
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Page Details</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h5>Page URL</h5>
                            <p>
                                <a href="{{ url('/page/' . $customPage->slug) }}" target="_blank">
                                    {{ url('/page/' . $customPage->slug) }}
                                </a>
                                <a href="{{ url('/page/' . $customPage->slug) }}" target="_blank" class="btn btn-sm btn-info ml-2">
                                    <i class="fas fa-external-link-alt"></i> View
                                </a>
                            </p>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Status</h5>
                            <span class="badge bg-{{ $customPage->active ? 'success' : 'danger' }} p-2">
                                {{ $customPage->active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Display Locations</h5>
                            <p>
                                @if($customPage->show_in_header)
                                    <span class="badge bg-info p-2">Header Navigation</span>
                                @endif
                                @if($customPage->show_in_footer)
                                    <span class="badge bg-secondary p-2">Footer Navigation</span>
                                @endif
                                @if(!$customPage->show_in_header && !$customPage->show_in_footer)
                                    <span class="badge bg-warning p-2">Not Displayed in Navigation</span>
                                @endif
                            </p>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Display Order</h5>
                            <p>{{ $customPage->order }}</p>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Creation & Updates</h5>
                            <p><strong>Created:</strong> {{ $customPage->created_at->format('M d, Y H:i') }}</p>
                            <p><strong>Last Updated:</strong> {{ $customPage->updated_at->format('M d, Y H:i') }}</p>
                            @if($customPage->creator)
                                <p><strong>Created By:</strong> {{ $customPage->creator->name }}</p>
                            @endif
                            @if($customPage->updater)
                                <p><strong>Last Updated By:</strong> {{ $customPage->updater->name }}</p>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">SEO Information</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h5>Meta Description</h5>
                            <p class="text-muted">{{ $customPage->meta_description ?: 'No meta description set' }}</p>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Meta Keywords</h5>
                            <p class="text-muted">{{ $customPage->meta_keywords ?: 'No meta keywords set' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-12">
                <div class="d-flex justify-content-between">
                    <div>
                        <a href="{{ route('admin.custom-pages.edit', $customPage) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit Page
                        </a>
                        <a href="{{ route('admin.custom-pages.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> All Pages
                        </a>
                    </div>
                    <form action="{{ route('admin.custom-pages.destroy', $customPage) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to move this page to trash?')">
                            <i class="fas fa-trash"></i> Move to Trash
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
<style>
    .content-preview {
        background-color: #fff;
        padding: 20px;
        border-radius: 5px;
        min-height: 300px;
    }
    .content-preview img {
        max-width: 100%;
        height: auto;
    }
</style>
@endsection 