@extends('admin.layouts.home')

@section('title', 'Events Management')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Events Management</h1>
        <div>
            <a href="{{ route('admin.events.statistics') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm mr-2">
                <i class="fas fa-chart-bar fa-sm text-white-50"></i> Statistics
            </a>
            <a href="{{ route('admin.events.featured') }}" class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm">
                <i class="fas fa-star fa-sm text-white-50"></i> Featured Events
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- Total Events Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upcoming Events Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Upcoming Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $upcomingEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Past Events Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Past Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $pastEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Featured Events Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Featured Events</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $featuredEvents }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-star fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Events</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.events.index') }}" method="GET" class="mb-0">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="status">Event Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="">All</option>
                            <option value="upcoming" {{ request('status') == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                            <option value="past" {{ request('status') == 'past' ? 'selected' : '' }}>Past</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="featured">Featured</label>
                        <select class="form-control" id="featured" name="featured">
                            <option value="">All</option>
                            <option value="yes" {{ request('featured') == 'yes' ? 'selected' : '' }}>Featured</option>
                            <option value="no" {{ request('featured') == 'no' ? 'selected' : '' }}>Not Featured</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="order_by">Order By</label>
                        <select class="form-control" id="order_by" name="order_by">
                            <option value="event_date" {{ request('order_by') == 'event_date' ? 'selected' : '' }}>Event Date</option>
                            <option value="created_at" {{ request('order_by') == 'created_at' ? 'selected' : '' }}>Creation Date</option>
                            <option value="title" {{ request('order_by') == 'title' ? 'selected' : '' }}>Title</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="order_direction">Direction</label>
                        <select class="form-control" id="order_direction" name="order_direction">
                            <option value="desc" {{ request('order_direction') == 'desc' ? 'selected' : '' }}>Descending</option>
                            <option value="asc" {{ request('order_direction') == 'asc' ? 'selected' : '' }}>Ascending</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="search">Search</label>
                        <input type="text" class="form-control" id="search" name="search" placeholder="Search by title, description or location" value="{{ request('search') }}">
                    </div>
                    <div class="col-md-6 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary mr-2">
                            <i class="fas fa-filter"></i> Apply Filters
                        </button>
                        <a href="{{ route('admin.events.index') }}" class="btn btn-secondary">
                            <i class="fas fa-sync"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Events Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">All Events</h6>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered" id="eventsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Location</th>
                            <th>Date & Time</th>
                            <th>Creator</th>
                            <th>Status</th>
                            <th>Featured</th>
                            <th>Attendees</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($events as $event)
                            <tr>
                                <td>{{ $event->id }}</td>
                                <td>
                                    @if($event->image)
                                        <img src="{{ asset('storage/' . $event->image) }}" alt="{{ $event->title }}" width="50" height="50" class="rounded">
                                    @else
                                        <div class="bg-light d-flex align-items-center justify-content-center rounded" style="width: 50px; height: 50px;">
                                            <i class="fas fa-calendar-alt text-gray-500"></i>
                                        </div>
                                    @endif
                                </td>
                                <td>{{ $event->title }}</td>
                                <td>{{ $event->location }}</td>
                                <td>
                                    {{ \Carbon\Carbon::parse($event->event_date)->format('M d, Y') }}
                                    <br>
                                    <small>{{ \Carbon\Carbon::parse($event->event_time)->format('h:i A') }}</small>
                                </td>
                                <td>
                                    @if($event->creator)
                                        <a href="{{ url('admin/users', $event->creator->id) }}">
                                            {{ $event->creator->name }}
                                        </a>
                                    @else
                                        <span class="text-muted">Unknown</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge badge-{{ $event->active ? 'success' : 'danger' }}">
                                        {{ $event->active ? 'Active' : 'Inactive' }}
                                    </span>
                                    @if(\Carbon\Carbon::parse($event->event_date)->isPast())
                                        <span class="badge badge-dark">Past</span>
                                    @else
                                        <span class="badge badge-info">Upcoming</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge badge-{{ $event->is_featured ? 'warning' : 'secondary' }}">
                                        {{ $event->is_featured ? 'Featured' : 'Not Featured' }}
                                    </span>
                                </td>
                                <td>
                                    {{ $event->attendees_count ?? 'N/A' }}
                                </td>
                                <td>{{ $event->created_at->format('M d, Y') }}</td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.events.show', $event->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form action="{{ route('admin.events.toggle-featured', $event->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-{{ $event->is_featured ? 'warning' : 'secondary' }} btn-sm">
                                                <i class="fas fa-{{ $event->is_featured ? 'star' : 'star' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.events.update-status', $event->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-{{ $event->active ? 'success' : 'danger' }} btn-sm">
                                                <i class="fas fa-{{ $event->active ? 'check' : 'times' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.events.destroy', $event->id) }}" method="POST" class="d-inline" 
                                            onsubmit="return confirm('Are you sure you want to delete this event? This action cannot be undone.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $events->appends(request()->query())->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection
