@extends('admin.layouts.home')

@section('title', 'Event Details')

@section('styles')
<style>
    .event-cover {
        height: 200px;
        background-size: cover;
        background-position: center;
        border-radius: 5px;
    }
    .user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }
    .tab-content {
        padding: 20px 0;
    }
    .badge-upcoming {
        background-color: #4e73df;
        color: white;
    }
    .badge-past {
        background-color: #858796;
        color: white;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Event Details</h1>
        <div>
            <a href="{{ route('admin.events.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Events
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- Left Column -->
        <div class="col-xl-8 col-lg-7">
            <!-- Event Details Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Event Information</h6>
                    <div>
                        <form action="{{ route('admin.events.toggle-featured', $event->id) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-sm btn-{{ $event->is_featured ? 'warning' : 'outline-warning' }}">
                                <i class="fas fa-star"></i> {{ $event->is_featured ? 'Unfeature' : 'Feature' }}
                            </button>
                        </form>
                        <form action="{{ route('admin.events.update-status', $event->id) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-sm btn-{{ $event->active ? 'success' : 'danger' }}">
                                <i class="fas fa-{{ $event->active ? 'check' : 'times' }}"></i> {{ $event->active ? 'Active' : 'Inactive' }}
                            </button>
                        </form>
                        <form action="{{ route('admin.events.destroy', $event->id) }}" method="POST" class="d-inline" 
                              onsubmit="return confirm('Are you sure you want to delete this event? This action cannot be undone.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if($event->image)
                        <div class="event-cover mb-4" style="background-image: url('{{ asset('storage/' . $event->image) }}')"></div>
                    @endif

                    <h2 class="h4 font-weight-bold text-gray-800">{{ $event->title }}</h2>
                    
                    <div class="mb-3">
                        <span class="badge badge-{{ $event->active ? 'success' : 'danger' }} mr-1">
                            {{ $event->active ? 'Active' : 'Inactive' }}
                        </span>
                        <span class="badge badge-{{ $event->is_featured ? 'warning' : 'secondary' }} mr-1">
                            {{ $event->is_featured ? 'Featured' : 'Not Featured' }}
                        </span>
                        <span class="badge badge-{{ \Carbon\Carbon::parse($event->event_date)->isPast() ? 'past' : 'upcoming' }}">
                            {{ \Carbon\Carbon::parse($event->event_date)->isPast() ? 'Past Event' : 'Upcoming Event' }}
                        </span>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <p class="mb-1"><i class="fas fa-map-marker-alt text-gray-500 mr-2"></i> <strong>Location:</strong> {{ $event->location }}</p>
                            <p class="mb-1"><i class="fas fa-calendar-day text-gray-500 mr-2"></i> <strong>Date:</strong> {{ \Carbon\Carbon::parse($event->event_date)->format('F d, Y') }}</p>
                            <p class="mb-1"><i class="fas fa-clock text-gray-500 mr-2"></i> <strong>Time:</strong> {{ \Carbon\Carbon::parse($event->event_time)->format('h:i A') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p class="mb-1"><i class="fas fa-users text-gray-500 mr-2"></i> <strong>Attendees:</strong> {{ $attendees->count() }}</p>
                            <p class="mb-1"><i class="fas fa-heart text-gray-500 mr-2"></i> <strong>Interests:</strong> {{ $interests->count() }}</p>
                            <p class="mb-1"><i class="fas fa-calendar-plus text-gray-500 mr-2"></i> <strong>Created:</strong> {{ $event->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5 class="font-weight-bold">Description</h5>
                        <p>{{ $event->description }}</p>
                    </div>

                    @if($event->creator)
                        <div class="mb-4">
                            <h5 class="font-weight-bold">Creator</h5>
                            <div class="d-flex align-items-center">
                                <img src="{{ $event->creator->profile_picture ? asset('storage/' . $event->creator->profile_picture) : asset('img/default-avatar.jpg') }}" alt="{{ $event->creator->name }}" class="user-avatar mr-2">
                                <div>
                                    <a href="{{ url('admin/users', $event->creator->id) }}">{{ $event->creator->name }}</a>
                                    <p class="text-muted mb-0 small">{{ $event->creator->email }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-xl-4 col-lg-5">
            <!-- Attendees Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Attendees</h6>
                </div>
                <div class="card-body">
                    @if($attendees->isEmpty())
                        <p class="text-center text-muted">No attendees yet</p>
                    @else
                        <div class="list-group">
                            @foreach($attendees->take(10) as $attendee)
                                <div class="list-group-item list-group-item-action d-flex align-items-center">
                                    <img src="{{ $attendee->user->profile_picture ? asset('storage/' . $attendee->user->profile_picture) : asset('img/default-avatar.jpg') }}" alt="{{ $attendee->user->name }}" class="user-avatar mr-3">
                                    <div>
                                        <a href="{{ url('admin/users', $attendee->user->id) }}">{{ $attendee->user->name }}</a>
                                        <p class="text-muted mb-0 small">{{ $attendee->created_at->format('M d, Y') }}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        @if($attendees->count() > 10)
                            <div class="text-center mt-3">
                                <span class="badge badge-light">+ {{ $attendees->count() - 10 }} more attendees</span>
                            </div>
                        @endif
                    @endif
                </div>
            </div>

            <!-- Interests Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Interested Users</h6>
                </div>
                <div class="card-body">
                    @if($interests->isEmpty())
                        <p class="text-center text-muted">No interests yet</p>
                    @else
                        <div class="list-group">
                            @foreach($interests->take(10) as $interest)
                                <div class="list-group-item list-group-item-action d-flex align-items-center">
                                    <img src="{{ $interest->user->profile_picture ? asset('storage/' . $interest->user->profile_picture) : asset('img/default-avatar.jpg') }}" alt="{{ $interest->user->name }}" class="user-avatar mr-3">
                                    <div>
                                        <a href="{{ url('admin/users', $interest->user->id) }}">{{ $interest->user->name }}</a>
                                        <p class="text-muted mb-0 small">{{ $interest->created_at->format('M d, Y') }}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        @if($interests->count() > 10)
                            <div class="text-center mt-3">
                                <span class="badge badge-light">+ {{ $interests->count() - 10 }} more interested users</span>
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 