@extends('admin.layouts.home')

@section('title', 'Add New Game Category')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add New Game Category</h1>
        <a href="{{ route('admin.games.categories.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left mr-1"></i> Back to Categories
        </a>
    </div>

    <!-- Category Form Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Category Information</h6>
        </div>
        <div class="card-body">
            @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form action="{{ route('admin.games.categories.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Category Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="icon">Icon Class <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i id="icon-preview" class="bi bi-gamepad"></i></span>
                                </div>
                                <input type="text" class="form-control" id="icon" name="icon" value="{{ old('icon', 'bi bi-gamepad') }}" required>
                            </div>
                            <small class="form-text text-muted">Enter a Bootstrap icon class (e.g., bi bi-controller, bi bi-puzzle). Use <a href="https://icons.getbootstrap.com/" target="_blank">Bootstrap Icons</a> for reference.</small>
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">Active</label>
                            </div>
                            <small class="form-text text-muted">If enabled, this category will be visible to users.</small>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="5">{{ old('description') }}</textarea>
                            <small class="form-text text-muted">Provide a brief description of the game category.</small>
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save mr-1"></i> Save Category
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Icon Reference Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Common Game Icons Reference</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-gamepad bi-2x text-primary mr-3"></i>
                        <code>bi bi-gamepad</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-puzzle bi-2x text-primary mr-3"></i>
                        <code>bi bi-puzzle</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-chess bi-2x text-primary mr-3"></i>
                        <code>bi bi-chess</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-car bi-2x text-primary mr-3"></i>
                        <code>bi bi-car</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-person-running bi-2x text-primary mr-3"></i>
                        <code>bi bi-person-running</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-bolt bi-2x text-primary mr-3"></i>
                        <code>bi bi-bolt</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-basketball bi-2x text-primary mr-3"></i>
                        <code>bi bi-basketball</code>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 mb-3">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-airplane-engines bi-2x text-primary mr-3"></i>
                        <code>bi bi-airplane-engines</code>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Update icon preview
    document.getElementById('icon').addEventListener('input', function() {
        const iconClass = this.value;
        const iconPreview = document.getElementById('icon-preview');
        
        // Remove all classes and add the new ones
        iconPreview.className = '';
        iconPreview.className = iconClass;
    });
</script>
@endpush
@endsection