@extends('admin.layouts.home')

@section('title', 'Featured Groups')


@section('content')
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <style>
        .group-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            height: 100%;
            border: none;
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            overflow: hidden;
        }
        .group-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .group-image {
            height: 180px;
            object-fit: cover;
            transition: transform 0.3s ease;
        }
        .group-card:hover .group-image {
            transform: scale(1.05);
        }
        .featured-badge {
            position: absolute;
            top: 10px;
            right: 0px;
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            padding: 6px 16px;
            border-radius: 20px;
            font-weight: 500;
            box-shadow: 0 2px 4px rgba(78, 115, 223, 0.3);
            backdrop-filter: blur(4px);
        }
        .group-info {
            padding: 1.25rem;
        }
        .group-stats {
            font-size: 0.875rem;
            color: #64748b;
            font-weight: 500;
        }
        .card-title {
            color: #1e293b;
            font-weight: 600;
            font-size: 1.125rem;
            line-height: 1.5;
            margin-bottom: 0.5rem;
        }
        .card-text {
            color: #475569;
            line-height: 1.5;
        }
        .btn {
            font-weight: 500;
            letter-spacing: 0.025em;
            transition: all 0.2s;
        }
        .btn-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border: none;
        }
        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 6px -1px rgba(78, 115, 223, 0.2);
        }
        .btn-warning {
            background: linear-gradient(135deg, #f6e05e 0%, #eab308 100%);
            border: none;
            color: #ffffff;
        }
        .btn-warning:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 6px -1px rgba(234, 179, 8, 0.2);
        }
    </style>
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-star-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Featured Groups</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item"><a href="{{ route('admin.groups.index') }}" class="text-white-50">Groups</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Featured Groups</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Featured Groups Section -->
        <div class="section-title">
            <h4 class="border-bottom pb-3"><i class="bi bi-star-fill text-warning me-2"></i> Currently Featured</h4>
        </div>
        
        @if($featuredGroups->isEmpty())
            <div class="alert alert-info bg-white border-0 shadow-sm">
                <div class="text-center py-4">
                    <i class="bi bi-star fs-1 text-primary mb-3"></i>
                    <h4 class="text-primary">No Featured Groups Yet</h4>
                    <p class="text-muted">Start featuring groups to give them more visibility</p>
                    <a href="{{ route('admin.groups.index') }}" class="btn btn-primary mt-2">
                        <i class="bi bi-list me-1"></i> Browse Groups
                    </a>
                </div>
            </div>
        @else
            <div class="row">
                @foreach($featuredGroups as $group)
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card group-card">
                            <div class="position-relative">
                                <img src="{{ getMedia($group->avatar) }}" class="card-img-top group-image" alt="{{ $group->name }}">
                                <span class="featured-badge">
                                    <i class="bi bi-star-fill me-1"></i> Featured
                                </span>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title mb-2">{{ $group->name }}</h5>
                                <p class="card-text text-muted small mb-3">{{ Str::limit($group->description, 80) }}</p>
                                
                                <div class="group-stats d-flex gap-3 mb-3">
                                    <span><i class="bi bi-people-fill me-1"></i> {{ $group->members_count ?? 0 }}</span>
                                    <span><i class="bi bi-chat-fill me-1"></i> {{ $group->posts_count ?? 0 }}</span>
                                    <span>
                                        <i class="bi {{ $group->is_private ? 'bi-lock-fill' : 'bi-globe' }} me-1"></i>
                                        {{ $group->is_private ? 'Private' : 'Public' }}
                                    </span>
                                </div>
                                
                                <div class="d-flex gap-2">
                                    <a href="{{ url('group/'.$group->slug) }}" class="btn btn-sm btn-primary flex-grow-1">
                                        <i class="bi bi-eye me-1"></i> View
                                    </a>
                                    <button type="button" class="btn btn-sm btn-warning" onclick="toggleFeatured({{ $group->id }})">
                                        <i class="bi bi-star"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $featuredGroups->links('pagination::bootstrap-5') }}
            </div>
        @endif

        <!-- Suggested Groups Section -->
        {{-- @if($suggestedGroups->isNotEmpty())
            <div class="section-title mt-5">
                <i class="bi bi-lightning-fill text-warning me-2"></i> Suggested Groups
            </div>
            <div class="row">
                @foreach($suggestedGroups as $group)
                    <div class="col-xl-3 col-md-6 mb-4" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">
                        <!-- Similar card structure as featured groups but with different styling -->
                        <div class="group-card">
                            <!-- ... Similar structure ... -->
                        </div>
                    </div>
                @endforeach
            </div>
        @endif --}}
    </div>
</div>

<script src="https://unpkg.com/aos@next/dist/aos.js"></script>
<script>
    AOS.init({
        duration: 800,
        once: true
    });

    function toggleFeatured(groupId) {
        fetch(`/admin/groups/${groupId}/toggle-featured`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire({
                    title: 'Success!',
                    text: data.message,
                    icon: 'success',
                    timer: 1500,
                    showConfirmButton: false
                }).then(() => {
                    window.location.reload();
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire(
                'Error!',
                'Something went wrong while updating featured status.',
                'error'
            );
        });
    }
</script>
@endsection