@extends('admin.layouts.home')

@section('title', 'Reported Groups')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Reported Groups</h1>
    </div>
    
    <!-- Status Filters -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Reports</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <form action="{{ route('admin.groups.reported') }}" method="GET" class="form-inline">
                        <div class="form-group mr-3">
                            <label for="status" class="mr-2">Status:</label>
                            <select name="status" id="status" class="form-control form-control-sm">
                                <option value="">All</option>
                                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="resolved" {{ request('status') === 'resolved' ? 'selected' : '' }}>Resolved</option>
                                <option value="dismissed" {{ request('status') === 'dismissed' ? 'selected' : '' }}>Dismissed</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-sm btn-primary">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        @if(request()->has('status'))
                            <a href="{{ route('admin.groups.reported') }}" class="btn btn-sm btn-secondary ml-2">
                                <i class="fas fa-times"></i> Clear
                            </a>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Reports Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Group Reports</h6>
            <div>
                @if($pendingCount > 0)
                    <span class="badge bg-warning">{{ $pendingCount }} pending</span>
                @endif
                <span class="badge bg-success ml-1">{{ $resolvedCount }} resolved</span>
                <span class="badge bg-secondary ml-1">{{ $dismissedCount }} dismissed</span>
            </div>
        </div>
        <div class="card-body">
            @if($reports->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle"></i> No reports found with the selected filters.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-bordered" id="reportsTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Group</th>
                                <th>Reported By</th>
                                <th>Reason</th>
                                <th>Reported On</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {{-- {{dd($reports)}} --}}
                            @foreach($reports as $report)
                                <tr class="{{ $report->status === 'pending' ? 'table-warning' : '' }}">
                                    <td>{{ $report->id }}</td>
                                    <td>
                                        <a href="{{ url('group/'.$report->group->slug) }}">
                                            {{ $report->group->name ?? 'Unknown Group' }}
                                        </a>
                                        <div class="small">
                                            <span class="badge bg-{{ $report->group->type === 'public' ? 'success' : 'warning' }}">
                                                <i class="fas {{ $report->group->type === 'public' ? 'fa-globe' : 'fa-lock' }}"></i>
                                                {{ ucfirst($report->group->type) }}
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ url('admin/users', $report->username) }}">
                                            {{ $report->user->name ?? 'Unknown User' }}
                                        </a>
                                    </td>
                                    <td>
                                        <strong>{{ $report->reason }}</strong>
                                        <div class="small text-muted">
                                            {{ Str::limit($report->details, 100) }}
                                            @if(strlen($report->details) > 100)
                                                <a href="#" data-toggle="modal" data-target="#reportDetails{{ $report->id }}">
                                                    (Read more)
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                    <td>{{ $report->created_at->format('D M-Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-{{ $report->status === 'pending' ? 'warning' : ($report->status === 'resolved' ? 'success' : 'secondary') }}">
                                            {{ ucfirst($report->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @if($report->status === 'pending')
                                                <form action="{{ route('admin.groups.update-report', $report->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('PUT')
                                                    <input type="hidden" name="status" value="resolved">
                                                    <button type="submit" class="btn btn-sm btn-success">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                                
                                                <form action="{{ route('admin.groups.update-report', $report->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('PUT')
                                                    <input type="hidden" name="status" value="dismissed">
                                                    <button type="submit" class="btn btn-sm btn-warning">
                                                        <i class="fas fa-ban"></i>
                                                    </button>
                                                </form>
                                                
                                                {{-- <form action="{{ route('admin.groups.update-group-status', $report->group_id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('PUT')
                                                    <input type="hidden" name="active" value="0">
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Deactivate Group" onclick="return confirm('Are you sure you want to deactivate this group?')">
                                                        <i class="fas fa-power-off"></i>
                                                    </button>
                                                </form> --}}
                                            @endif
                                            
                                            <form action="{{ route('admin.groups.delete-report', $report->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="btn btn-sm btn-danger" title="Delete Report" onclick="return confirm('Are you sure you want to delete this report?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Report Details Modal -->
                                <div class="modal fade" id="reportDetails{{ $report->id }}" tabindex="-1" role="dialog" aria-labelledby="reportDetailsLabel{{ $report->id }}" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="reportDetailsLabel{{ $report->id }}">Report Details</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <h6>Group: {{ $report->group->name ?? 'Unknown Group' }}</h6>
                                                <h6>Reported By: {{ $report->user->name ?? 'Unknown User' }}</h6>
                                                <h6>Reason: {{ $report->reason }}</h6>
                                                <h6>Date: {{ $report->created_at }}</h6>
                                                <hr>
                                                <h6>Details:</h6>
                                                <p>{{ $report->details }}</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <a href="{{ route('admin.groups.show', $report->group_id) }}" class="btn btn-primary">
                                                    <i class="fas fa-eye"></i> View Group
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="mt-4">
                    {{ $reports->appends(request()->query())->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#reportsTable').DataTable({
            "order": [[4, "desc"]],
            "pageLength": 25,
            "searching": true,
            "info": true,
            "paging": false,
            "columnDefs": [
                { "orderable": false, "targets": 6 }
            ]
        });
    });
</script>
@endsection 