@extends('admin.layouts.home')

@section('title', 'Edit Help Center Topic')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Help Center Topic</h1>
        <a href="{{ route('admin.help-center.topics.index') }}" class="btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Topics
        </a>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Topic Details</h6>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.help-center.topics.update', $topic) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $topic->title) }}" required>
                        </div>

                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug', $topic->slug) }}">
                            <small class="form-text text-muted">Used in URLs. Leave blank to auto-generate.</small>
                        </div>

                        <div class="mb-3">
                            <label for="icon" class="form-label">Icon class</label>
                            <input type="text" class="form-control" id="icon" name="icon" value="{{ old('icon', $topic->icon) }}" placeholder="e.g., fas fa-question-circle">
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Overview</label>
                            <textarea class="form-control" id="description" name="description" rows="5">{{ old('description', $topic->description) }}</textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="display_order" class="form-label">Display Order</label>
                                <input type="number" class="form-control" id="display_order" name="display_order" value="{{ old('display_order', $topic->display_order) }}" min="0">
                            </div>
                            <div class="col-md-6 mb-3 d-flex align-items-end">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $topic->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">Visible to users</label>
                                </div>
                            </div>
                        </div>

                        <div class="card border-0 bg-light">
                            <div class="card-body">
                                <h6 class="fw-bold mb-3">SEO</h6>
                                <div class="mb-3">
                                    <label for="meta_title" class="form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ old('meta_title', $topic->meta_title) }}">
                                </div>
                                <div class="mb-3">
                                    <label for="meta_description" class="form-label">Meta Description</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description" rows="3">{{ old('meta_description', $topic->meta_description) }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">Update Topic</button>
                            <a href="{{ route('admin.help-center.topics.index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Topic Insights</h6>
                </div>
                <div class="card-body">
                    <p class="text-muted">This topic currently has <strong>{{ $topic->articles()->count() }}</strong> articles.</p>
                    <ul class="mb-0">
                        <li class="mb-2">Reordering impacts how quickly users can find this topic.</li>
                        <li class="mb-2">Toggle visibility when you want to draft content without publishing.</li>
                        <li class="mb-0">Use the SEO fields for better discoverability via search.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
