@extends('admin.layouts.home')

@section('title', 'Manage Jobs')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">All Jobs</h4>
                    <a href="{{ route('admin.jobs.stats') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-chart-bar"></i> Job Statistics
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Company</th>
                                    <th>Category</th>
                                    <th>Posted By</th>
                                    <th>Status</th>
                                    <th>Expires</th>
                                    <th>Applications</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($jobs as $job)
                                    <tr>
                                        <td>{{ $job->id }}</td>
                                        <td>{{ $job->job_title }}</td>
                                        <td>{{ $job->company_name }}</td>
                                        <td>{{ $job->category->name ?? 'N/A' }}</td>
                                        <td>{{ $job->user->name ?? 'N/A' }}</td>
                                        <td>
                                            <span class="badge bg-{{ $job->status == 'approved' ? 'success' : ($job->status == 'pending' ? 'warning' : 'danger') }}">
                                                {{ ucfirst($job->status) }}
                                            </span>
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($job->expiry_date)->format('M d, Y') }}</td>
                                        <td>
                                            <a href="{{ route('admin.jobs.applications', $job->id) }}" class="btn btn-sm btn-info">
                                                View Applications
                                            </a>
                                        </td>
                                        <td class="d-flex">
                                            <a href="{{ route('admin.jobs.show', $job->id) }}" class="btn btn-sm btn-info me-1">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.jobs.edit', $job->id) }}" class="btn btn-sm btn-primary me-1">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.jobs.toggle-status', $job->id) }}" method="POST" class="d-inline me-1">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="btn btn-sm {{ $job->status == 'approved' ? 'btn-warning' : 'btn-success' }}">
                                                    <i class="fas {{ $job->status == 'approved' ? 'fa-ban' : 'fa-check' }}"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.jobs.destroy', $job->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this job?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">No jobs found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $jobs->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 