@extends('admin.layouts.home')

@section('title', 'Job Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Job Details</h4>
                    <div>
                        <a href="{{ route('admin.jobs.applications', $job->id) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-users"></i> View Applications
                        </a>
                        <a href="{{ route('admin.jobs.edit', $job->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> Edit Job
                        </a>
                        <a href="{{ route('admin.jobs.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="job-header mb-4">
                        <div class="d-flex align-items-center">
                            @if($job->company_logo)
                                <img src="{{ Storage::url($job->company_logo) }}" alt="{{ $job->company_name }}" class="img-thumbnail me-3" style="max-width: 100px;">
                            @endif
                            <div>
                                <h3>{{ $job->job_title }}</h3>
                                <h5>{{ $job->company_name }}</h5>
                                <div class="badge bg-{{ $job->status == 'approved' ? 'success' : ($job->status == 'pending' ? 'warning' : 'danger') }} mb-2">
                                    {{ ucfirst($job->status) }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Job Details</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <tr>
                                            <th>Category:</th>
                                            <td>{{ $job->category->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Job Type:</th>
                                            <td>{{ ucfirst(str_replace('-', ' ', $job->job_type)) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Salary:</th>
                                            <td>
                                                @if($job->salary_display == 'show')
                                                    {{ $job->currency }} {{ number_format($job->minimum_salary) }} - {{ number_format($job->maximum_salary) }}
                                                @else
                                                    Hidden
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Experience:</th>
                                            <td>{{ $job->experience_years }} year(s)</td>
                                        </tr>
                                        <tr>
                                            <th>Location:</th>
                                            <td>
                                                {{ ucfirst($job->work_location_type) }}
                                                @if($job->work_location_type != 'remote')
                                                    - {{ $job->city }}, {{ $job->state }}, {{ $job->country }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Posted By:</th>
                                            <td>{{ $job->user->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Posted On:</th>
                                            <td>{{ $job->created_at->format('M d, Y') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Expires On:</th>
                                            <td>{{ \Carbon\Carbon::parse($job->expiry_date)->format('M d, Y') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Company Information</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <tr>
                                            <th>Company Name:</th>
                                            <td>{{ $job->company_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Website:</th>
                                            <td>
                                                @if($job->company_website)
                                                    <a href="{{ $job->company_website }}" target="_blank">{{ $job->company_website }}</a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Application Method:</th>
                                            <td>{{ ucfirst($job->application_method) }}</td>
                                        </tr>
                                        @if($job->application_method == 'email')
                                            <tr>
                                                <th>Application Email:</th>
                                                <td>{{ $job->application_email }}</td>
                                            </tr>
                                        @elseif($job->application_method == 'website')
                                            <tr>
                                                <th>Application URL:</th>
                                                <td>
                                                    <a href="{{ $job->application_url }}" target="_blank">{{ $job->application_url }}</a>
                                                </td>
                                            </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Job Description</h5>
                                </div>
                                <div class="card-body">
                                    {!! $job->job_description !!}
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($job->key_responsibilities)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Key Responsibilities</h5>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        @foreach(json_decode($job->key_responsibilities, true) ?? [] as $responsibility)
                                            <li>{{ $responsibility }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($job->requirements)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Requirements</h5>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        @foreach(json_decode($job->requirements, true) ?? [] as $requirement)
                                            <li>{{ $requirement }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($job->skills)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Required Skills</h5>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex flex-wrap">
                                        @foreach(json_decode($job->skills, true) ?? [] as $skill)
                                            <span class="badge bg-primary m-1">{{ $skill }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 