@extends('admin.layouts.home')

@section('title', 'Reviews Management')

@section('styles')
<style>
    .review-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 10px;
        overflow: hidden;
    }
    
    .review-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .filter-card {
        border-radius: 10px;
        margin-bottom: 20px;
    }
    
    .action-btn {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }
    
    .action-btn:hover {
        transform: translateY(-2px);
    }
    
    .product-thumbnail {
        width: 50px;
        height: 50px;
        object-fit: cover;
        border-radius: 8px;
    }
    
    .user-avatar {
        width: 40px;
        height: 40px;
        object-fit: cover;
        border-radius: 50%;
    }
    
    .star-rating {
        color: #ffc107;
    }
    
    .review-text {
        max-height: 80px;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
    }
</style>
@endsection

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="mt-4">Reviews Management</h1>
        <div>
            <a href="{{ route('admin.marketplace.dashboard') }}" class="btn btn-outline-primary me-2">
                <i class="fas fa-chart-line me-1"></i> Dashboard
            </a>
        </div>
    </div>
    
    <!-- Filter Card -->
    <div class="card filter-card mb-4">
        <div class="card-header bg-light">
            <i class="fas fa-filter me-1"></i> Filter Reviews
        </div>
        <div class="card-body">
            <form action="{{ route('admin.marketplace.reviews') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="rating" class="form-label">Rating</label>
                    <select class="form-select" id="rating" name="rating">
                        <option value="">All Ratings</option>
                        <option value="5" {{ request('rating') == '5' ? 'selected' : '' }}>5 Stars</option>
                        <option value="4" {{ request('rating') == '4' ? 'selected' : '' }}>4 Stars</option>
                        <option value="3" {{ request('rating') == '3' ? 'selected' : '' }}>3 Stars</option>
                        <option value="2" {{ request('rating') == '2' ? 'selected' : '' }}>2 Stars</option>
                        <option value="1" {{ request('rating') == '1' ? 'selected' : '' }}>1 Star</option>
                    </select>
                </div>
                
                <div class="col-md-3">
                    <label for="product" class="form-label">Product</label>
                    <select class="form-select" id="product" name="product">
                        <option value="">All Products</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ request('product') == $product->id ? 'selected' : '' }}>
                                {{ Str::limit($product->name, 30) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-3">
                    <label for="order_by" class="form-label">Order By</label>
                    <select class="form-select" id="order_by" name="order_by">
                        <option value="created_at" {{ request('order_by') == 'created_at' ? 'selected' : '' }}>Date Created</option>
                        <option value="rating" {{ request('order_by') == 'rating' ? 'selected' : '' }}>Rating</option>
                    </select>
                </div>
                
                <div class="col-md-3">
                    <label for="order_direction" class="form-label">Direction</label>
                    <select class="form-select" id="order_direction" name="order_direction">
                        <option value="desc" {{ request('order_direction') == 'desc' ? 'selected' : '' }}>Descending</option>
                        <option value="asc" {{ request('order_direction') == 'asc' ? 'selected' : '' }}>Ascending</option>
                    </select>
                </div>
                
                <div class="col-md-9">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Search by review text, product name, or customer name...">
                </div>
                
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-search me-1"></i> Apply Filters
                    </button>
                    <a href="{{ route('admin.marketplace.reviews') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-redo me-1"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Reviews List -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-star me-1"></i>
            Reviews List
            <span class="badge bg-primary ms-2">{{ $reviews->total() }} Reviews</span>
        </div>
        <div class="card-body">
            @if($reviews->isEmpty())
                <div class="alert alert-info">
                    No reviews found. Try adjusting your filters.
                </div>
            @else
                <div class="row">
                    @foreach($reviews as $review)
                        <div class="col-lg-6 mb-4">
                            <div class="card review-card h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-3">
                                        <div class="d-flex">
                                            @if($review->user && $review->user->avatar)
                                                <img src="{{ asset('storage/' . $review->user->avatar) }}" alt="{{ $review->user->name }}" class="user-avatar me-2">
                                            @else
                                                <div class="user-avatar bg-light d-flex align-items-center justify-content-center me-2">
                                                    <i class="fas fa-user text-secondary"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <h6 class="mb-0">{{ $review->user->name ?? 'Anonymous' }}</h6>
                                                <div class="star-rating">
                                                    @for($i = 1; $i <= 5; $i++)
                                                        @if($i <= $review->rating)
                                                            <i class="fas fa-star"></i>
                                                        @else
                                                            <i class="far fa-star"></i>
                                                        @endif
                                                    @endfor
                                                </div>
                                                <small class="text-muted">{{ $review->created_at->format('M d, Y') }}</small>
                                            </div>
                                        </div>
                                        <div>
                                            <form action="{{ route('admin.marketplace.reviews.destroy', $review->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this review?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger action-btn">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <p class="review-text">{{ $review->review }}</p>
                                    </div>
                                    
                                    <div class="d-flex align-items-center mt-3 pt-3 border-top">
                                        @if($review->product)
                                            <div class="d-flex align-items-center">
                                                @if($review->product->thumbnail)
                                                    <img src="{{ asset('storage/' . $review->product->thumbnail) }}" alt="{{ $review->product->name }}" class="product-thumbnail me-2">
                                                @else
                                                    <div class="product-thumbnail bg-light d-flex align-items-center justify-content-center me-2">
                                                        <i class="fas fa-box text-secondary"></i>
                                                    </div>
                                                @endif
                                                <div>
                                                    <a href="{{ route('admin.marketplace.products.show', $review->product->id) }}" class="text-decoration-none">
                                                        <div class="fw-bold">{{ Str::limit($review->product->name, 30) }}</div>
                                                        @if($review->product->store)
                                                            <div class="small text-muted">{{ $review->product->store->name }}</div>
                                                        @endif
                                                    </a>
                                                </div>
                                            </div>
                                        @else
                                            <span class="text-muted">Product not available</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $reviews->appends(request()->query())->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
    
    <!-- Rating Statistics -->
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-chart-bar me-1"></i>
            Rating Statistics
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-lg-6">
                    <div class="mb-4">
                        <h5>Rating Distribution</h5>
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-1">
                                <div style="width: 80px">5 Stars</div>
                                <div class="progress flex-grow-1" style="height: 20px">
                                    @php
                                        $fiveStarPercentage = $reviews->where('rating', 5)->count() / ($reviews->count() ?: 1) * 100;
                                    @endphp
                                    <div class="progress-bar bg-success" role="progressbar" style="width: {{ $fiveStarPercentage }}%" aria-valuenow="{{ $fiveStarPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                        {{ round($fiveStarPercentage) }}%
                                    </div>
                                </div>
                                <div class="ms-2" style="width: 40px">{{ $reviews->where('rating', 5)->count() }}</div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-1">
                                <div style="width: 80px">4 Stars</div>
                                <div class="progress flex-grow-1" style="height: 20px">
                                    @php
                                        $fourStarPercentage = $reviews->where('rating', 4)->count() / ($reviews->count() ?: 1) * 100;
                                    @endphp
                                    <div class="progress-bar bg-primary" role="progressbar" style="width: {{ $fourStarPercentage }}%" aria-valuenow="{{ $fourStarPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                        {{ round($fourStarPercentage) }}%
                                    </div>
                                </div>
                                <div class="ms-2" style="width: 40px">{{ $reviews->where('rating', 4)->count() }}</div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-1">
                                <div style="width: 80px">3 Stars</div>
                                <div class="progress flex-grow-1" style="height: 20px">
                                    @php
                                        $threeStarPercentage = $reviews->where('rating', 3)->count() / ($reviews->count() ?: 1) * 100;
                                    @endphp
                                    <div class="progress-bar bg-info" role="progressbar" style="width: {{ $threeStarPercentage }}%" aria-valuenow="{{ $threeStarPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                        {{ round($threeStarPercentage) }}%
                                    </div>
                                </div>
                                <div class="ms-2" style="width: 40px">{{ $reviews->where('rating', 3)->count() }}</div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-1">
                                <div style="width: 80px">2 Stars</div>
                                <div class="progress flex-grow-1" style="height: 20px">
                                    @php
                                        $twoStarPercentage = $reviews->where('rating', 2)->count() / ($reviews->count() ?: 1) * 100;
                                    @endphp
                                    <div class="progress-bar bg-warning" role="progressbar" style="width: {{ $twoStarPercentage }}%" aria-valuenow="{{ $twoStarPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                        {{ round($twoStarPercentage) }}%
                                    </div>
                                </div>
                                <div class="ms-2" style="width: 40px">{{ $reviews->where('rating', 2)->count() }}</div>
                            </div>
                            
                            <div class="d-flex align-items-center">
                                <div style="width: 80px">1 Star</div>
                                <div class="progress flex-grow-1" style="height: 20px">
                                    @php
                                        $oneStarPercentage = $reviews->where('rating', 1)->count() / ($reviews->count() ?: 1) * 100;
                                    @endphp
                                    <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $oneStarPercentage }}%" aria-valuenow="{{ $oneStarPercentage }}" aria-valuemin="0" aria-valuemax="100">
                                        {{ round($oneStarPercentage) }}%
                                    </div>
                                </div>
                                <div class="ms-2" style="width: 40px">{{ $reviews->where('rating', 1)->count() }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="text-center mb-4">
                        <h5>Average Rating</h5>
                        <div class="display-4 fw-bold text-primary mb-2">
                            @php
                                $avgRating = $reviews->avg('rating') ?? 0;
                            @endphp
                            {{ number_format($avgRating, 1) }}
                        </div>
                        <div class="star-rating mb-2">
                            @for($i = 1; $i <= 5; $i++)
                                @if($i <= round($avgRating))
                                    <i class="fas fa-star fa-2x"></i>
                                @else
                                    <i class="far fa-star fa-2x"></i>
                                @endif
                            @endfor
                        </div>
                        <div class="text-muted">Based on {{ $reviews->count() }} reviews</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 