@extends('admin.layouts.home')

@section('title', 'Marketplace Settings')

@section('styles')
<style>
    .settings-card {
        transition: all 0.3s ease;
        margin-bottom: 1.5rem;
        border-radius: 0.5rem;
        border-left: 4px solid #4e73df;
    }
    
    .settings-card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        transform: translateY(-2px);
    }
    
    .settings-icon {
        font-size: 2rem;
        color: #4e73df;
        margin-bottom: 1rem;
    }
    
    .badge-setting {
        font-size: 0.8rem;
        padding: 0.25rem 0.5rem;
        margin-left: 0.5rem;
    }
    
    .config-section {
        padding: 1.5rem;
        border-radius: 0.5rem;
        background-color: #f8f9fc;
        margin-bottom: 1.5rem;
    }
    
    .form-hint {
        font-size: 0.85rem;
        color: #858796;
        margin-top: 0.25rem;
    }
    
    .spacer {
        height: 1px;
        background-color: #e3e6f0;
        margin: 1.5rem 0;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Marketplace Settings</h1>
        <a href="{{ route('admin.marketplace.dashboard') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Dashboard
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <form action="{{ route('admin.marketplace.update-settings') }}" method="POST">
        @csrf
        <div class="row">
            <!-- General Settings -->
            <div class="col-lg-6">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">General Settings</h6>
                        <div>
                            <span class="badge badge-info badge-setting">Core</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <label for="marketplace_name">Marketplace Name</label>
                            <input type="text" class="form-control" id="marketplace_name" name="settings[marketplace_name]" value="{{ $settings['marketplace_name'] ?? 'SociaLink Marketplace' }}">
                            <div class="form-hint">The name of your marketplace as displayed to users.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="marketplace_tagline">Marketplace Tagline</label>
                            <input type="text" class="form-control" id="marketplace_tagline" name="settings[marketplace_tagline]" value="{{ $settings['marketplace_tagline'] ?? 'Buy and sell with your community' }}">
                            <div class="form-hint">A short description or slogan for your marketplace.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="marketplace_description">Marketplace Description</label>
                            <textarea class="form-control" id="marketplace_description" name="settings[marketplace_description]" rows="3">{{ $settings['marketplace_description'] ?? 'A place to buy and sell products and services within your community.' }}</textarea>
                            <div class="form-hint">A longer description of your marketplace for SEO and information purposes.</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="marketplace_active" name="settings[marketplace_active]" value="1" {{ ($settings['marketplace_active'] ?? true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="marketplace_active">Marketplace Active</label>
                            </div>
                            <div class="form-hint">Enable or disable the entire marketplace functionality.</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="allow_guest_browsing" name="settings[allow_guest_browsing]" value="1" {{ ($settings['allow_guest_browsing'] ?? true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="allow_guest_browsing">Allow Guest Browsing</label>
                            </div>
                            <div class="form-hint">Allow non-logged-in users to browse products (they will still need to log in to purchase).</div>
                        </div>
                    </div>
                </div>
                
                <!-- Product Settings -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Product Settings</h6>
                        <div>
                            <span class="badge badge-info badge-setting">Products</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <label for="max_product_images">Maximum Product Images</label>
                            <input type="number" class="form-control" id="max_product_images" name="settings[max_product_images]" value="{{ $settings['max_product_images'] ?? 5 }}" min="1" max="10">
                            <div class="form-hint">Maximum number of images allowed per product.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="allowed_product_categories">Product Categories Per Product</label>
                            <input type="number" class="form-control" id="allowed_product_categories" name="settings[allowed_product_categories]" value="{{ $settings['allowed_product_categories'] ?? 3 }}" min="1" max="5">
                            <div class="form-hint">Maximum number of categories that can be assigned to a product.</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="moderate_new_products" name="settings[moderate_new_products]" value="1" {{ ($settings['moderate_new_products'] ?? false) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="moderate_new_products">Moderate New Products</label>
                            </div>
                            <div class="form-hint">Require admin approval before new products are visible in the marketplace.</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="allow_product_reviews" name="settings[allow_product_reviews]" value="1" {{ ($settings['allow_product_reviews'] ?? true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="allow_product_reviews">Allow Product Reviews</label>
                            </div>
                            <div class="form-hint">Enable or disable product reviews functionality.</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Store & Seller Settings -->
            <div class="col-lg-6">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Store & Seller Settings</h6>
                        <div>
                            <span class="badge badge-info badge-setting">Stores</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="anyone_can_sell" name="settings[anyone_can_sell]" value="1" {{ ($settings['anyone_can_sell'] ?? true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="anyone_can_sell">Anyone Can Sell</label>
                            </div>
                            <div class="form-hint">Allow any registered user to create a store and sell products.</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="moderate_new_stores" name="settings[moderate_new_stores]" value="1" {{ ($settings['moderate_new_stores'] ?? true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="moderate_new_stores">Moderate New Stores</label>
                            </div>
                            <div class="form-hint">Require admin approval before new stores are visible in the marketplace.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="store_min_description_length">Minimum Store Description Length</label>
                            <input type="number" class="form-control" id="store_min_description_length" name="settings[store_min_description_length]" value="{{ $settings['store_min_description_length'] ?? 50 }}" min="10" max="1000">
                            <div class="form-hint">Minimum required length for store descriptions.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="seller_verification_requirements">Seller Verification Requirements</label>
                            <select class="form-control" id="seller_verification_requirements" name="settings[seller_verification_requirements]">
                                <option value="none" {{ ($settings['seller_verification_requirements'] ?? 'email') === 'none' ? 'selected' : '' }}>None</option>
                                <option value="email" {{ ($settings['seller_verification_requirements'] ?? 'email') === 'email' ? 'selected' : '' }}>Email Verification</option>
                                <option value="phone" {{ ($settings['seller_verification_requirements'] ?? 'email') === 'phone' ? 'selected' : '' }}>Phone Verification</option>
                                <option value="both" {{ ($settings['seller_verification_requirements'] ?? 'email') === 'both' ? 'selected' : '' }}>Both Email & Phone</option>
                                <option value="id" {{ ($settings['seller_verification_requirements'] ?? 'email') === 'id' ? 'selected' : '' }}>ID Verification</option>
                            </select>
                            <div class="form-hint">Requirements sellers must meet before they can sell products.</div>
                        </div>
                    </div>
                </div>
                
                <!-- Financial Settings -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Financial Settings</h6>
                        <div>
                            <span class="badge badge-info badge-setting">Payments</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <label for="default_currency">Default Currency</label>
                            <select class="form-control" id="default_currency" name="settings[default_currency]">
                                <option value="USD" {{ ($settings['default_currency'] ?? 'USD') === 'USD' ? 'selected' : '' }}>USD ($)</option>
                                <option value="EUR" {{ ($settings['default_currency'] ?? 'USD') === 'EUR' ? 'selected' : '' }}>EUR (€)</option>
                                <option value="GBP" {{ ($settings['default_currency'] ?? 'USD') === 'GBP' ? 'selected' : '' }}>GBP (£)</option>
                                <option value="CAD" {{ ($settings['default_currency'] ?? 'USD') === 'CAD' ? 'selected' : '' }}>CAD ($)</option>
                                <option value="AUD" {{ ($settings['default_currency'] ?? 'USD') === 'AUD' ? 'selected' : '' }}>AUD ($)</option>
                                <option value="JPY" {{ ($settings['default_currency'] ?? 'USD') === 'JPY' ? 'selected' : '' }}>JPY (¥)</option>
                            </select>
                            <div class="form-hint">Default currency for all transactions.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="platform_fee_percentage">Platform Fee (%)</label>
                            <input type="number" class="form-control" id="platform_fee_percentage" name="settings[platform_fee_percentage]" value="{{ $settings['platform_fee_percentage'] ?? 5 }}" min="0" max="100" step="0.01">
                            <div class="form-hint">Percentage of each sale that goes to the platform.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="payout_minimum">Minimum Payout Amount</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="payout-addon">$</span>
                                </div>
                                <input type="number" class="form-control" id="payout_minimum" name="settings[payout_minimum]" aria-describedby="payout-addon" value="{{ $settings['payout_minimum'] ?? 25 }}" min="0" step="0.01">
                            </div>
                            <div class="form-hint">Minimum amount a seller must earn before requesting a payout.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="payout_schedule">Payout Schedule</label>
                            <select class="form-control" id="payout_schedule" name="settings[payout_schedule]">
                                <option value="manual" {{ ($settings['payout_schedule'] ?? 'monthly') === 'manual' ? 'selected' : '' }}>Manual Requests Only</option>
                                <option value="weekly" {{ ($settings['payout_schedule'] ?? 'monthly') === 'weekly' ? 'selected' : '' }}>Weekly</option>
                                <option value="biweekly" {{ ($settings['payout_schedule'] ?? 'monthly') === 'biweekly' ? 'selected' : '' }}>Bi-weekly</option>
                                <option value="monthly" {{ ($settings['payout_schedule'] ?? 'monthly') === 'monthly' ? 'selected' : '' }}>Monthly</option>
                            </select>
                            <div class="form-hint">How often automatic payouts are processed for sellers.</div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="tax_rate">Default Tax Rate (%)</label>
                            <input type="number" class="form-control" id="tax_rate" name="settings[tax_rate]" value="{{ $settings['tax_rate'] ?? 0 }}" min="0" max="100" step="0.01">
                            <div class="form-hint">Default tax rate applied to purchases. May be overridden by location-specific rates.</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Notification Settings -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Notification Settings</h6>
                        <div>
                            <span class="badge badge-info badge-setting">Notifications</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="mb-3">Admin Notifications</h5>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_new_store" name="settings[notify_new_store]" value="1" {{ ($settings['notify_new_store'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_new_store">New Store Created</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_new_product" name="settings[notify_new_product]" value="1" {{ ($settings['notify_new_product'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_new_product">New Product Added</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_new_order" name="settings[notify_new_order]" value="1" {{ ($settings['notify_new_order'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_new_order">New Order Placed</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_product_reported" name="settings[notify_product_reported]" value="1" {{ ($settings['notify_product_reported'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_product_reported">Product Reported</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_payout_request" name="settings[notify_payout_request]" value="1" {{ ($settings['notify_payout_request'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_payout_request">Payout Request</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <h5 class="mb-3">Customer Notifications</h5>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_customer_order_confirmation" name="settings[notify_customer_order_confirmation]" value="1" {{ ($settings['notify_customer_order_confirmation'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_customer_order_confirmation">Order Confirmation</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_customer_shipping_update" name="settings[notify_customer_shipping_update]" value="1" {{ ($settings['notify_customer_shipping_update'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_customer_shipping_update">Shipping Updates</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_customer_order_delivered" name="settings[notify_customer_order_delivered]" value="1" {{ ($settings['notify_customer_order_delivered'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_customer_order_delivered">Order Delivered</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_review_reminder" name="settings[notify_review_reminder]" value="1" {{ ($settings['notify_review_reminder'] ?? true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_review_reminder">Review Reminder</label>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="notify_customer_promotional" name="settings[notify_customer_promotional]" value="1" {{ ($settings['notify_customer_promotional'] ?? false) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="notify_customer_promotional">Promotional Emails</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row mb-4">
            <div class="col-lg-12">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save mr-2"></i> Save Settings
                </button>
                <a href="{{ route('admin.marketplace.dashboard') }}" class="btn btn-secondary btn-lg ml-2">
                    <i class="fas fa-times mr-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Toggle dependent settings based on parent settings
        $('#marketplace_active').change(function() {
            if (!$(this).is(':checked')) {
                $('#allow_guest_browsing').prop('disabled', true);
                $('#allow_guest_browsing').prop('checked', false);
            } else {
                $('#allow_guest_browsing').prop('disabled', false);
            }
        });
        
        $('#allow_product_reviews').change(function() {
            if (!$(this).is(':checked')) {
                $('#notify_review_reminder').prop('disabled', true);
                $('#notify_review_reminder').prop('checked', false);
            } else {
                $('#notify_review_reminder').prop('disabled', false);
            }
        });
        
        // Auto-initialize dependent settings
        if (!$('#marketplace_active').is(':checked')) {
            $('#allow_guest_browsing').prop('disabled', true);
        }
        
        if (!$('#allow_product_reviews').is(':checked')) {
            $('#notify_review_reminder').prop('disabled', true);
        }
    });
</script>
@endsection 