@extends('admin.layouts.home')

@section('title', 'Pages Management')

@section('content')
<style>
    .active-badge{
        position: absolute;
        top: 10px;
        right: 10px;
    }

    .card-title a{
        text-decoration: none;
    }

    .featured{
        position: absolute;
        top: 10px;
        left: 10px;
        color: white;
        font-size: 20px;
        border: none;
        background: none;
        cursor: pointer;
        background-color: none !important;
    }

    .featured:hover, .featured:active{
        border: none;
        background: none;
        cursor: pointer;
        background-color: none !important;
        color: important;
    }

    .featured.active, .featured:hover{
        color: #ffc107 !important;
    }

    .btn-del{
        position: absolute;
        bottom: 10px;
        right: 10px;
        color: white;
    }
</style>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Pages Management</h1>
        <div>
            <a href="{{ route('admin.pages.statistics') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm mr-2">
                <i class="fas fa-chart-bar fa-sm text-white-50"></i> Statistics
            </a>
            <a href="{{ route('admin.pages.featured') }}" class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm">
                <i class="fas fa-star fa-sm text-white-50"></i> Featured Pages
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- Total Pages Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalPages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Active Pages Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $activePages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inactive Pages Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Inactive Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $inactivePages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Featured Pages Card -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Featured Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $featuredPages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-star fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Pages</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.pages.index') }}" method="GET" class="mb-0">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="category">Category</label>
                        <select name="category" id="category" class="form-control">
                            <option value="all">All Categories</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">All</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="featured">Featured</label>
                        <select name="featured" id="featured" class="form-control">
                            <option value="">All</option>
                            <option value="yes" {{ request('featured') == 'yes' ? 'selected' : '' }}>Featured</option>
                            <option value="no" {{ request('featured') == 'no' ? 'selected' : '' }}>Not Featured</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="search">Search</label>
                        <input type="text" name="search" id="search" class="form-control" placeholder="Search pages..." value="{{ request('search') }}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="order_by">Order By</label>
                        <select name="order_by" id="order_by" class="form-control">
                            <option value="created_at" {{ request('order_by') == 'created_at' ? 'selected' : '' }}>Date Created</option>
                            <option value="name" {{ request('order_by') == 'name' ? 'selected' : '' }}>Name</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label for="order_dir">Order Direction</label>
                        <select name="order_dir" id="order_dir" class="form-control">
                            <option value="desc" {{ request('order_dir') == 'desc' ? 'selected' : '' }}>Descending</option>
                            <option value="asc" {{ request('order_dir') == 'asc' ? 'selected' : '' }}>Ascending</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary mr-2">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="{{ route('admin.pages.index') }}" class="btn btn-secondary">
                            <i class="fas fa-sync-alt"></i> Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Pages Cards -->
    <div class="row">
        @if(session('success'))
            <div class="col-12">
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            </div>
        @endif

        @forelse($pages as $page)
            <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                <div class="card shadow h-100 page-card position-relative">
                        <div class="position-relative">
                            <img src="{{ getMedia($page->cover_photo) }}" class="card-img-top" alt="{{ $page->page_title }}" style="height: 150px; object-fit: cover;">
                            <form action="{{ route('admin.pages.destroy', $page->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm text-danger btn-del" title="Delete" onclick="return confirm('Are you sure you want to delete this page?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                        <span class="badge bg-{{ $page->active ? 'success' : 'danger' }} active-badge">
                            {{ $page->active ? 'Active' : 'Inactive' }}
                        </span>
                        
                        <form action="{{ route('admin.pages.toggle-featured', $page->id) }}" method="POST" class="d-inline">
                            @csrf
                                <button type="submit" class="featured btn btn-sm {{ $page->is_featured ? 'active' : '' }}" title="{{ $page->is_featured ? 'Remove from featured' : 'Add to featured' }}"><i class="fa fa-star"></i></button>
                        </form>
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="{{ route('admin.pages.show', $page->id) }}">{{ $page->page_title }}</a>
                        </h5>
                        <p class="card-text small text-muted">{{ Str::limit($page->description, 50) }}</p>
                        
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            @if($page->category)
                                <span class="badge bg-info">{{ $page->category->name }}</span>
                            @else
                                <span class="badge bg-secondary">Uncategorized</span>
                            @endif
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">{{ $page->created_at->format('M d, Y') }}</small>
                            <span class="badge bg-{{ $page->is_featured ? 'warning' : 'secondary' }}">
                                {{ $page->is_featured ? 'Featured' : 'Unfeatured' }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="card-footer bg-white">
                        <div class="btn-group d-flex w-100">
                            <a href="{{ route('admin.pages.edit', $page->id) }}" class="btn btn-sm btn-primary" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            
                            {{-- <form action="{{ route('admin.pages.update-status', $page->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="active" value="{{ $page->active ? 0 : 1 }}">
                                <button type="submit" class="btn btn-sm btn-{{ $page->active ? 'success' : 'danger' }}" title="{{ $page->active ? 'Deactivate' : 'Activate' }}">
                                    <i class="fas fa-{{ $page->active ? 'check' : 'times' }}"></i>
                                </button>
                            </form> --}}
                            
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="alert alert-info">
                    No pages found.
                </div>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $pages->links('pagination::bootstrap-5') }}
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#pagesTable').DataTable({
            "paging": false,
            "ordering": false,
            "info": false,
            "searching": false
        });
    });
</script>
@endsection