@extends('admin.layouts.home')

@section('title', 'Page Details')

@section('styles')
<style>
    .page-cover {
        height: 200px;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        border-radius: 0.35rem;
    }
    .user-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
    }
    .tab-content {
        padding: 20px;
        border: 1px solid #e3e6f0;
        border-top: none;
        border-radius: 0 0 0.35rem 0.35rem;
    }
    .nav-tabs .nav-link.active {
        border-color: #e3e6f0 #e3e6f0 #fff;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Page Details</h1>
        <div>
            <a href="{{ route('admin.pages.edit', $page->id) }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm mr-2">
                <i class="fas fa-edit fa-sm text-white-50"></i> Edit Page
            </a>
            <a href="{{ route('admin.pages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Pages
            </a>
        </div>
    </div>

    <!-- Page Info Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Page Information</h6>
            <div>
                @if($page->is_featured)
                    <form action="{{ route('admin.pages.toggle-featured', $page->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-warning">
                            <i class="fas fa-star"></i> Remove from Featured
                        </button>
                    </form>
                @else
                    <form action="{{ route('admin.pages.toggle-featured', $page->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-outline-warning">
                            <i class="far fa-star"></i> Add to Featured
                        </button>
                    </form>
                @endif

                @if($page->active)
                    <form action="{{ route('admin.pages.update-status', $page->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="active" value="0">
                        <button type="submit" class="btn btn-sm btn-danger">
                            <i class="fas fa-ban"></i> Deactivate Page
                        </button>
                    </form>
                @else
                    <form action="{{ route('admin.pages.update-status', $page->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="active" value="1">
                        <button type="submit" class="btn btn-sm btn-success">
                            <i class="fas fa-check"></i> Activate Page
                        </button>
                    </form>
                @endif

                <form action="{{ route('admin.pages.destroy', $page->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this page? This action cannot be undone.')">
                        <i class="fas fa-trash"></i> Delete Page
                    </button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4 mb-4">
                    @if($page->cover_photo)
                        <div class="page-cover mb-3" style="background-image: url('{{ asset('storage/' . $page->cover_photo) }}');"></div>
                    @else
                        <div class="page-cover mb-3 bg-light d-flex align-items-center justify-content-center">
                            <i class="fas fa-file-alt fa-4x text-gray-400"></i>
                        </div>
                    @endif
                    
                    <div class="card mb-3">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Quick Stats</h6>
                        </div>
                        <div class="card-body">
                            <div class="row no-gutters align-items-center mb-2">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Likes</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $likeCount }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-thumbs-up fa-2x text-gray-300"></i>
                                </div>
                            </div>
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Posts</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $postCount }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-newspaper fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Contact Information</h6>
                        </div>
                        <div class="card-body">
                            @if($page->location)
                                <p><i class="fas fa-map-marker-alt mr-2"></i> {{ $page->location }}</p>
                            @endif
                            
                            @if($page->website)
                                <p><i class="fas fa-globe mr-2"></i> <a href="{{ $page->website }}" target="_blank">{{ $page->website }}</a></p>
                            @endif
                            
                            @if($page->phone)
                                <p><i class="fas fa-phone mr-2"></i> {{ $page->phone }}</p>
                            @endif
                            
                            @if($page->email)
                                <p><i class="fas fa-envelope mr-2"></i> {{ $page->email }}</p>
                            @endif
                            
                            @if(!$page->location && !$page->website && !$page->phone && !$page->email)
                                <p class="text-muted">No contact information available</p>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-8">
                    <h4>{{ $page->name }} 
                        <span class="badge bg-{{ $page->active ? 'success' : 'danger' }}">
                            {{ $page->active ? 'Active' : 'Inactive' }}
                        </span>
                        @if($page->is_featured)
                            <span class="badge bg-warning">
                                <i class="fas fa-star"></i> Featured
                            </span>
                        @endif
                    </h4>
                    
                    <p class="text-muted">{{ $page->description }}</p>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <p><strong>Category:</strong> 
                                @if($page->category)
                                    <span class="badge bg-info">{{ $page->category->name }}</span>
                                @else
                                    <span class="badge bg-secondary">Uncategorized</span>
                                @endif
                            </p>
                            <p><strong>Created:</strong> {{ $page->created_at->format('M d, Y') }}</p>
                            <p><strong>Last Updated:</strong> {{ $page->updated_at->format('M d, Y') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Creator:</strong> 
                                @if($page->creator)
                                    <a href="{{ url('admin/users', $page->creator->id) }}">{{ $page->creator->name }}</a>
                                @else
                                    <span class="text-muted">Unknown</span>
                                @endif
                            </p>
                        </div>
                    </div>
                    
                    <!-- Tabs Navigation -->
                    <ul class="nav nav-tabs mt-4" id="pageTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="likes-tab" data-toggle="tab" href="#likes" role="tab" aria-controls="likes" aria-selected="true">
                                <i class="fas fa-thumbs-up"></i> Recent Likes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="posts-tab" data-toggle="tab" href="#posts" role="tab" aria-controls="posts" aria-selected="false">
                                <i class="fas fa-newspaper"></i> Recent Posts
                            </a>
                        </li>
                    </ul>
                    
                    <!-- Tab Content -->
                    <div class="tab-content" id="pageTabsContent">
                        <!-- Likes Tab -->
                        <div class="tab-pane fade show active" id="likes" role="tabpanel" aria-labelledby="likes-tab">
                            @if($recentLikes->isEmpty())
                                <p class="text-muted">No likes yet.</p>
                            @else
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($recentLikes as $like)
                                                <tr>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            @if($like->user->profile_photo)
                                                                <img src="{{ asset('storage/' . $like->user->profile_photo) }}" class="user-avatar mr-2" alt="">
                                                            @else
                                                                <div class="bg-primary text-white rounded-circle mr-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                    {{ strtoupper(substr($like->user->name, 0, 1)) }}
                                                                </div>
                                                            @endif
                                                            <div>
                                                                <a href="{{ url('admin/users', $like->user->id) }}">{{ $like->user->name }}</a>
                                                                <div class="small text-muted">{{ $like->user->email }}</div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>{{ $like->created_at->format('M d, Y H:i') }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                
                                @if($likeCount > count($recentLikes))
                                    <div class="text-center mt-3">
                                        <p class="text-muted">Showing {{ count($recentLikes) }} of {{ $likeCount }} likes</p>
                                    </div>
                                @endif
                            @endif
                        </div>
                        
                        <!-- Posts Tab -->
                        <div class="tab-pane fade" id="posts" role="tabpanel" aria-labelledby="posts-tab">
                            <p class="text-muted">Recent posts will be displayed here.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Handle tab switching using URL hash
        var hash = window.location.hash;
        if (hash) {
            $('#pageTabs a[href="'+hash+'"]').tab('show');
        }
        
        // Change hash on tab click
        $('#pageTabs a').on('click', function(e) {
            window.location.hash = $(this).attr('href');
        });
    });
</script>
@endsection 