@extends('admin.layouts.home')

@section('title', 'Poke Statistics')

@section('content')
<div class="container-fluid bg-white p-4 rounded shadow-sm">
    

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm mb-4 h-100">
                <div class="card-body text-center">
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <i class="bi bi-hand-index-thumb text-primary" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title">Total Pokes</h5>
                    <p class="card-text display-4 font-weight-bold text-primary">{{ number_format($totalPokes) }}</p>
                    <p class="text-muted small">All time poke interactions</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm mb-4 h-100">
                <div class="card-body text-center">
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <i class="bi bi-calendar-check text-success" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title">Pokes Today</h5>
                    <p class="card-text display-4 font-weight-bold text-success">{{ number_format($todayPokes) }}</p>
                    <p class="text-muted small">Pokes sent in the last 24 hours</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm mb-4 h-100">
                <div class="card-body text-center">
                    <div class="d-flex align-items-center justify-content-center mb-3">
                        <i class="bi bi-envelope text-warning" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title">Unread Pokes</h5>
                    <p class="card-text display-4 font-weight-bold text-warning">{{ number_format($unreadPokes) }}</p>
                    <p class="text-muted small">Pokes waiting to be seen</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-send mr-1"></i> Top Senders
                    </h6>
                    <span class="badge bg-primary rounded-pill">{{ count($topSenders) }}</span>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @foreach($topSenders as $index => $sender)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="badge bg-secondary rounded-pill mr-2">{{ $index + 1 }}</span>
                                    <span>{{ $sender->name }}</span>
                                </div>
                                <span class="badge bg-primary rounded-pill">{{ number_format($sender->poke_count) }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="bi bi-inbox mr-1"></i> Top Receivers
                    </h6>
                    <span class="badge bg-primary rounded-pill">{{ count($topReceivers) }}</span>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        @foreach($topReceivers as $index => $receiver)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="badge bg-secondary rounded-pill mr-2">{{ $index + 1 }}</span>
                                    <span>{{ $receiver->name }}</span>
                                </div>
                                <span class="badge bg-primary rounded-pill">{{ number_format($receiver->poke_count) }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 