@extends('admin.layouts.home')

@section('title', 'Report Detail')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Report #{{ $report->id }}</h1>
        <div>
            <a href="{{ route('admin.reports.module-reports') }}" class="btn btn-sm btn-secondary mr-2">
                <i class="fas fa-arrow-left"></i> All Reports
            </a>
            @if($report->module_route)
                <a href="{{ $report->module_route }}" target="_blank" class="btn btn-sm btn-primary">
                    <i class="fas fa-external-link-alt"></i> View Module
                </a>
            @endif
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-4 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Reporter</h6>
                </div>
                <div class="card-body text-center">
                    <img src="{{ $report->reporter->profile_photo ?? asset('assets/images/default-avatar.png') }}"
                         class="rounded-circle mb-3" width="90" height="90" alt="Reporter avatar">
                    <h5 class="mb-1">
                        {{ $report->reporter->name ?? 'User unavailable' }}
                    </h5>
                    <p class="text-muted mb-2">
                        @if($report->reporter)
                            ID: {{ $report->reporter->id }}<br>
                            {{ $report->reporter->email }}
                        @else
                            This user record is no longer available.
                        @endif
                    </p>
                    <span class="badge badge-info">Reported {{ $report->created_at?->diffForHumans() }}</span>
                </div>
            </div>
        </div>

        <div class="col-lg-8 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Report Information</h6>
                    <span class="badge badge-{{ $report->status_badge }}">{{ $report->status_label }}</span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p class="mb-1 text-muted">Module</p>
                            <p class="font-weight-bold mb-3">
                                {{ $report->module_label }}
                                <small class="d-block text-muted">ID: {{ $report->module_id }}</small>
                                @if($report->module_title)
                                    <small class="d-block text-muted">“{{ \Illuminate\Support\Str::limit($report->module_title, 60) }}”</small>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p class="mb-1 text-muted">Reported At</p>
                            <p class="font-weight-bold mb-3">{{ $report->created_at?->format('M d, Y H:i') }}</p>
                            <p class="mb-1 text-muted">Last Updated</p>
                            <p class="font-weight-bold mb-0">{{ $report->updated_at?->format('M d, Y H:i') }}</p>
                        </div>
                    </div>

                    <hr>

                    <p class="mb-1 text-muted">Reason</p>
                    <p class="font-weight-bold">{{ $report->reason }}</p>

                    <hr>

                    <div class="d-flex flex-wrap align-items-center">
                        <form action="{{ route('admin.reports.module-reports.action') }}" method="POST" class="mr-2 mb-2" onsubmit="return confirm('Accepting will remove the reported module. Continue?');">
                            @csrf
                            <input type="hidden" name="report_id" value="{{ $report->id }}">
                            <input type="hidden" name="action" value="approve">
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-check"></i> Accept
                            </button>
                        </form>

                        <form action="{{ route('admin.reports.module-reports.action') }}" method="POST" class="mb-2" onsubmit="return confirm('Rejecting will notify the reporter and dismiss this report. Continue?');">
                            @csrf
                            <input type="hidden" name="report_id" value="{{ $report->id }}">
                            <input type="hidden" name="action" value="reject">
                            <button type="submit" class="btn btn-danger btn-sm">
                                <i class="fas fa-times"></i> Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Other Reports for This {{ $report->module_label }}</h6>
        </div>
        <div class="card-body">
            @if($relatedReports->isEmpty())
                <p class="text-muted mb-0">No other reports were filed for this module.</p>
            @else
                <div class="table-responsive">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Reporter</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Reported At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($relatedReports as $related)
                                <tr>
                                    <td>#{{ $related->id }}</td>
                                    <td>{{ $related->reporter->name ?? 'Unknown user' }}</td>
                                    <td>{{ \Illuminate\Support\Str::limit($related->reason, 60) }}</td>
                                    <td>
                                        <span class="badge badge-{{ $related->status_badge }}">{{ $related->status_label }}</span>
                                    </td>
                                    <td>{{ $related->created_at?->format('M d, Y H:i') }}</td>
                                    <td>
                                        <a href="{{ route('admin.reports.module-reports.show', $related->id) }}" class="btn btn-outline-primary btn-sm">
                                            View
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

