@extends('admin.layouts.home')

@section('title', 'Other Reports')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">All Other Reports</h1>
        <a href="{{ route('admin.reports.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Dashboard
        </a>
    </div>

    <!-- Summary Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $counts['pending'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Resolved</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $counts['resolved'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-secondary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">Dismissed</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $counts['dismissed'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-ban fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $counts['total'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Tabs -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Reports</h6>
        </div>
        <div class="card-body">
            @php
                $statusStyles = [
                    'all' => 'info',
                    'pending' => 'warning',
                    'resolved' => 'success',
                    'dismissed' => 'secondary',
                ];
            @endphp
            <ul class="nav nav-pills mb-3">
                @foreach($statusLabels as $key => $label)
                    @php
                        $isActive = $statusFilter === $key;
                        $pillClass = $isActive ? 'active bg-' . ($statusStyles[$key] ?? 'primary') : '';
                        $count = $key === 'all' ? $counts['total'] : ($counts[$key] ?? 0);
                    @endphp
                    <li class="nav-item mr-2 mb-2">
                        <a class="nav-link {{ $pillClass }}"
                           href="{{ route('admin.reports.module-reports', array_merge(request()->except('page'), ['status' => $key])) }}">
                            <i class="fas fa-filter mr-1"></i> {{ $label }}
                            <span class="badge bg-light text-dark ml-1">{{ $count }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>

    <!-- Reports Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Other Reports</h6>
            <span class="text-muted small">Showing {{ $reports->firstItem() ?? 0 }} - {{ $reports->lastItem() ?? 0 }} of {{ $reports->total() }}</span>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if($reports->isEmpty())
                <div class="text-center py-5">
                    <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                    <p class="lead text-muted mb-0">No reports found for the selected filter.</p>
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>From User</th>
                                <th>Module</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>View Detail</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($reports as $report)
                                <tr>
                                    <td>#{{ $report->id }}</td>
                                    <td>
                                        @if($report->reporter)
                                            <div class="d-flex align-items-center">
                                                <img src="{{ $report->reporter->profile_photo ?? asset('assets/images/default-avatar.png') }}"
                                                     class="rounded-circle mr-2" width="40" height="40" alt="Reporter avatar">
                                                <div>
                                                    <strong>{{ $report->reporter->name }}</strong><br>
                                                    <small class="text-muted">ID: {{ $report->reporter->id }}</small>
                                                </div>
                                            </div>
                                        @else
                                            <span class="text-muted">User not available</span>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>{{ $report->module_label }}</strong><br>
                                        @if($report->module_title)
                                            <small class="text-muted">“{{ \Illuminate\Support\Str::limit($report->module_title, 40) }}”</small><br>
                                        @endif
                                        <small class="text-muted">Module ID: {{ $report->module_id }}</small>
                                    </td>
                                    <td style="max-width: 220px;">
                                        <span class="d-inline-block text-truncate" style="max-width: 210px;" title="{{ $report->reason }}">
                                            {{ $report->reason }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $report->status_badge }}">{{ $report->status_label }}</span>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $report->created_at?->format('M d, Y H:i') }}</small>
                                    </td>
                                    <td>
                                        @if($report->module_route)
                                            <a href="{{ $report->module_route }}" target="_blank" class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-external-link-alt"></i> View Module
                                            </a>
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <a href="{{ route('admin.reports.module-reports.show', $report->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                {{ $reports->links() }}
            @endif
        </div>
    </div>
</div>
@endsection

