@extends('admin.layouts.home')

@section('title', 'Post Reports')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Post Reports</h1>
        <a href="{{ route('admin.reports.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to Dashboard
        </a>
    </div>

    <!-- Status Filter -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Reports</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <ul class="nav nav-pills mb-3">
                        <li class="nav-item">
                            <a class="nav-link {{ $status == 'pending' ? 'active bg-warning' : '' }}" href="{{ route('admin.reports.post-reports', ['status' => 'pending']) }}">
                                <i class="fas fa-clock mr-1"></i> Pending
                                <span class="badge bg-light">{{ $pendingPostReportsCount }}</span>
                            </a>
                        </li>
                        <li class="nav-item ml-2">
                            <a class="nav-link {{ $status == 'resolved' ? 'active bg-success' : '' }}" href="{{ route('admin.reports.post-reports', ['status' => 'resolved']) }}">
                                <i class="fas fa-check-circle mr-1"></i> Resolved
                                <span class="badge bg-light">{{ $resolvedPostReportsCount }}</span>
                            </a>
                        </li>
                        <li class="nav-item ml-2">
                            <a class="nav-link {{ $status == 'dismissed' ? 'active bg-danger' : '' }}" href="{{ route('admin.reports.post-reports', ['status' => 'dismissed']) }}">
                                <i class="fas fa-ban mr-1"></i> Dismissed
                                <span class="badge bg-light">{{ $dismissedPostReportsCount }}</span>
                            </a>
                        </li>
                        <li class="nav-item ml-2">
                            <a class="nav-link {{ $status == 'all' ? 'active bg-info' : '' }}" href="{{ route('admin.reports.post-reports', ['status' => 'all']) }}">
                                <i class="fas fa-list mr-1"></i> All Reports
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Reports Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                {{ ucfirst($status) }} Post Reports
            </h6>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered" id="reportsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Post</th>
                            <th>Reported By</th>
                            <th>Reason</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reports as $report)
                            <tr>
                                <td>{{ $report->id }}</td>
                                <td>
                                    @if($report->post)
                                        <div class="d-flex align-items-center">
                                            @if($report->post->media && count($report->post->media) > 0)
                                                <img src="{{ asset($report->post->media[0]->url) }}" 
                                                    class="rounded mr-2" width="60" height="60" style="object-fit: cover;">
                                            @else
                                                <div class="rounded mr-2 bg-light d-flex align-items-center justify-content-center" 
                                                    style="width: 60px; height: 60px;">
                                                    <i class="fas fa-file-alt text-secondary"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <strong>{{ Str::limit($report->post->text, 30) }}</strong>
                                                <br>
                                                <small class="text-muted">ID: {{ $report->post_id }}</small>
                                                <br>
                                                <small class="text-muted">By: {{ $report->post->user->name ?? 'Unknown' }}</small>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted">Post not found or deleted</span>
                                    @endif
                                </td>
                                <td>
                                    @if($report->reportingUser)
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $report->reportingUser->profile_photo ?? asset('assets/images/default-avatar.png') }}" 
                                                class="rounded-circle mr-2" width="40" height="40">
                                            <div>
                                                <strong>{{ $report->reportingUser->name }}</strong>
                                                <br>
                                                <small class="text-muted">ID: {{ $report->user_id }}</small>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-muted">User not found</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="d-inline-block text-truncate" style="max-width: 200px;">
                                        {{ $report->reason }}
                                    </span>
                                </td>
                                <td>
                                    @if($report->status == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($report->status == 'resolved')
                                        <span class="badge bg-success">Resolved</span>
                                    @elseif($report->status == 'dismissed')
                                        <span class="badge bg-danger">Dismissed</span>
                                    @endif
                                </td>
                                <td>{{ $report->created_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.reports.post-reports.show', $report->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if($report->status == 'pending')
                                            <button type="button" class="btn btn-success btn-sm" 
                                                data-toggle="modal" data-target="#resolveModal{{ $report->id }}">
                                                <i class="fas fa-check"></i>
                                            </button>
                                            <button type="button" class="btn btn-danger btn-sm" 
                                                data-toggle="modal" data-target="#dismissModal{{ $report->id }}">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        @endif
                                        <form action="{{ route('admin.reports.post-reports.delete', $report->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" 
                                                onclick="return confirm('Are you sure you want to delete this report?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>

                                    <!-- Resolve Modal -->
                                    <div class="modal fade" id="resolveModal{{ $report->id }}" tabindex="-1" role="dialog" aria-labelledby="resolveModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="resolveModalLabel">Resolve Report</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('admin.reports.post-reports.update-status', $report->id) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-body">
                                                        <input type="hidden" name="status" value="resolved">
                                                        <p>What action would you like to take against the reported post?</p>
                                                        <div class="form-group">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="actionNone{{ $report->id }}" name="action" value="none" class="custom-control-input" checked>
                                                                <label class="custom-control-label" for="actionNone{{ $report->id }}">No action (just mark as resolved)</label>
                                                            </div>
                                                            <div class="custom-control custom-radio mt-2">
                                                                <input type="radio" id="actionHide{{ $report->id }}" name="action" value="hide" class="custom-control-input">
                                                                <label class="custom-control-label" for="actionHide{{ $report->id }}">Hide post</label>
                                                            </div>
                                                            <div class="custom-control custom-radio mt-2">
                                                                <input type="radio" id="actionDelete{{ $report->id }}" name="action" value="delete" class="custom-control-input">
                                                                <label class="custom-control-label" for="actionDelete{{ $report->id }}">Delete post</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-success">Resolve Report</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Dismiss Modal -->
                                    <div class="modal fade" id="dismissModal{{ $report->id }}" tabindex="-1" role="dialog" aria-labelledby="dismissModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="dismissModalLabel">Dismiss Report</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{ route('admin.reports.post-reports.update-status', $report->id) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-body">
                                                        <input type="hidden" name="status" value="dismissed">
                                                        <input type="hidden" name="action" value="none">
                                                        <p>Are you sure you want to dismiss this report?</p>
                                                        <p class="text-muted">Dismissing a report indicates that no violation has occurred and no action is needed.</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-danger">Dismiss Report</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No reports found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $reports->appends(['status' => $status])->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('#reportsTable').DataTable({
        "paging": false, // Let Laravel handle pagination
        "ordering": true,
        "info": false,
        "searching": true,
    });
});
</script>
@endsection 