@extends('admin.layouts.home')

@section('title', 'User Report Details')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">User Report Details</h1>
        <a href="{{ route('admin.reports.user-reports') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to User Reports
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- Report Info Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Report Information</h6>
            <div>
                @if($report->status == 'pending')
                    <span class="badge bg-warning py-1 px-2">Pending</span>
                @elseif($report->status == 'resolved')
                    <span class="badge bg-success py-1 px-2">Resolved</span>
                @elseif($report->status == 'dismissed')
                    <span class="badge bg-danger py-1 px-2">Dismissed</span>
                @endif
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="mb-3">Report Details</h5>
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 150px;">Report ID</th>
                            <td>{{ $report->id }}</td>
                        </tr>
                        <tr>
                            <th>Date Reported</th>
                            <td>{{ $report->created_at->format('F d, Y h:i A') }}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                @if($report->status == 'pending')
                                    <span class="badge bg-warning">Pending</span>
                                @elseif($report->status == 'resolved')
                                    <span class="badge bg-success">Resolved</span>
                                @elseif($report->status == 'dismissed')
                                    <span class="badge bg-danger">Dismissed</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Last Updated</th>
                            <td>{{ $report->updated_at->format('F d, Y h:i A') }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h5 class="mb-3">Reason for Report</h5>
                    <div class="card bg-light">
                        <div class="card-body">
                            <p>{{ $report->reason }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Reported User Card -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Reported User</h6>
                </div>
                <div class="card-body">
                    @if($report->reportedUser)
                        <div class="text-center mb-4">
                            <img src="{{ $report->reportedUser->profile_photo ?? asset('assets/images/default-avatar.png') }}" 
                                class="img-profile rounded-circle" width="100" height="100">
                            <h5 class="mt-3">{{ $report->reportedUser->name }}</h5>
                            <p class="text-muted">{{ $report->reportedUser->email }}</p>
                            <div class="mt-2">
                                @if($report->reportedUser->is_blocked)
                                    <span class="badge bg-danger">Blocked</span>
                                @else
                                    <span class="badge bg-success">Active</span>
                                @endif
                            </div>
                        </div>
                        <div class="row text-center">
                            <div class="col-4 border-right">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $report->reportedUser->posts_count ?? 0 }}</div>
                                <div class="small text-gray-500">Posts</div>
                            </div>
                            <div class="col-4 border-right">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $report->reportedUser->followers_count ?? 0 }}</div>
                                <div class="small text-gray-500">Followers</div>
                            </div>
                            <div class="col-4">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $userReports->count() }}</div>
                                <div class="small text-gray-500">Reports</div>
                            </div>
                        </div>

                        <div class="divider my-4"></div>

                        <div class="text-center mb-3">
                            <h6 class="font-weight-bold">User Reports History</h6>
                        </div>

                        @if(count($userReports) > 0)
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Reason</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($userReports as $userReport)
                                            <tr @if($userReport->id == $report->id) class="table-active" @endif>
                                                <td>{{ $userReport->created_at->format('M d, Y') }}</td>
                                                <td>
                                                    <span class="d-inline-block text-truncate" style="max-width: 150px;">
                                                        {{ $userReport->reason }}
                                                    </span>
                                                </td>
                                                <td>
                                                    @if($userReport->status == 'pending')
                                                        <span class="badge bg-warning">Pending</span>
                                                    @elseif($userReport->status == 'resolved')
                                                        <span class="badge bg-success">Resolved</span>
                                                    @elseif($userReport->status == 'dismissed')
                                                        <span class="badge bg-danger">Dismissed</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-center text-muted">No previous reports found.</p>
                        @endif
                    @else
                        <div class="text-center py-5">
                            <div class="text-gray-500 mb-3">
                                <i class="fas fa-user-slash fa-4x"></i>
                            </div>
                            <h5>User Not Found</h5>
                            <p class="text-muted">The reported user may have been deleted from the system.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Reporting User</h6>
                </div>
                <div class="card-body">
                    @if($report->reportingUser)
                        <div class="text-center mb-4">
                            <img src="{{ $report->reportingUser->profile_photo ?? asset('assets/images/default-avatar.png') }}" 
                                class="img-profile rounded-circle" width="100" height="100">
                            <h5 class="mt-3">{{ $report->reportingUser->name }}</h5>
                            <p class="text-muted">{{ $report->reportingUser->email }}</p>
                            <div class="mt-2">
                                @if($report->reportingUser->is_blocked)
                                    <span class="badge bg-danger">Blocked</span>
                                @else
                                    <span class="badge bg-success">Active</span>
                                @endif
                            </div>
                        </div>
                        <div class="row text-center">
                            <div class="col-6 border-right">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $report->reportingUser->posts_count ?? 0 }}</div>
                                <div class="small text-gray-500">Posts</div>
                            </div>
                            <div class="col-6">
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $reportsSubmittedCount }}</div>
                                <div class="small text-gray-500">Reports Submitted</div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="text-gray-500 mb-3">
                                <i class="fas fa-user-slash fa-4x"></i>
                            </div>
                            <h5>User Not Found</h5>
                            <p class="text-muted">The reporting user may have been deleted from the system.</p>
                        </div>
                    @endif
                </div>
            </div>

            @if($report->status == 'pending')
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Take Action</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#resolveModal">
                                    <i class="fas fa-check mr-1"></i> Resolve Report
                                </button>
                            </div>
                            <div class="col-md-6 mb-3">
                                <button type="button" class="btn btn-danger btn-block" data-toggle="modal" data-target="#dismissModal">
                                    <i class="fas fa-ban mr-1"></i> Dismiss Report
                                </button>
                            </div>
                        </div>

                        <div class="divider my-4"></div>

                        <form action="{{ route('admin.reports.user-reports.delete', $report->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger btn-block" 
                                onclick="return confirm('Are you sure you want to delete this report?')">
                                <i class="fas fa-trash mr-1"></i> Delete Report
                            </button>
                        </form>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Resolve Modal -->
    <div class="modal fade" id="resolveModal" tabindex="-1" role="dialog" aria-labelledby="resolveModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="resolveModalLabel">Resolve Report</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.reports.user-reports.update-status', $report->id) }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="status" value="resolved">
                        <p>What action would you like to take against the reported user?</p>
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <input type="radio" id="actionNone" name="action" value="none" class="custom-control-input" checked>
                                <label class="custom-control-label" for="actionNone">No action (just mark as resolved)</label>
                            </div>
                            <div class="custom-control custom-radio mt-2">
                                <input type="radio" id="actionBlock" name="action" value="block" class="custom-control-input">
                                <label class="custom-control-label" for="actionBlock">Block user</label>
                            </div>
                            <div class="custom-control custom-radio mt-2">
                                <input type="radio" id="actionDelete" name="action" value="delete" class="custom-control-input">
                                <label class="custom-control-label" for="actionDelete">Delete user</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Resolve Report</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Dismiss Modal -->
    <div class="modal fade" id="dismissModal" tabindex="-1" role="dialog" aria-labelledby="dismissModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="dismissModalLabel">Dismiss Report</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('admin.reports.user-reports.update-status', $report->id) }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="status" value="dismissed">
                        <input type="hidden" name="action" value="none">
                        <p>Are you sure you want to dismiss this report?</p>
                        <p class="text-muted">Dismissing a report indicates that no violation has occurred and no action is needed.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Dismiss Report</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 