@extends('admin.layouts.home')
@section('title')
    {{ __('Video & Audio Settings') }}
@endsection

@section('content')
    <div class="main-content">
        <div class="page-content">
            <!-- Page Header with Breadcrumbs -->
            <div class="content-header mb-4">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <div class="col-12">
                            <div class="card bg-primary text-white mb-3">
                                <div class="card-body py-4">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                            <i class="bi bi-camera-video-fill fs-1"></i>
                                        </div>
                                        <div>
                                            <h1 class="m-0 fw-bold">{{ __('Video & Audio Settings') }}</h1>
                                            <nav aria-label="breadcrumb">
                                                <ol class="breadcrumb mb-0 text-white-50">
                                                    <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('/admin') }}" class="text-white-50">{{ __('Dashboard') }}</a></li>
                                                    <li class="breadcrumb-item active text-white" aria-current="page">{{ __('Video & Audio Settings') }}</li>
                                                </ol>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons Row -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body p-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-0">{{ __('Video & Audio Configuration') }}</h5>
                                    <p class="text-muted mb-0">{{ __('Configure your chat and video/audio call settings') }}</p>
                                </div>
                                <div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Content -->
            <div class="row">
                <div class="col-lg-6">
                    <!-- Chat Settings Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-chat-dots"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Chat Settings') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Chat System Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-chat_system" class="form-label fw-bold mb-0">{{ __('Chat System') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable chat system to chat with friends on the bottom right of the page') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="chck-chat_system" name="chat_system" {{active_value_check(setting('chat_system') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Message Seen Alert Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-message_seen" class="form-label fw-bold mb-0">{{ __('Message Seen Alert') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Checks if the message was seen in chat system. Recommended for powerful servers.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="chck-message_seen" name="message_seen" {{active_value_check(setting('message_seen') ?? 0)}}>
                                </div>
                            </div>

                            <!-- User Typing System Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-typing_system" class="form-label fw-bold mb-0">{{ __('User Typing System') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Checks if the user is typing in chat system. Recommended for powerful servers.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="chck-typing_system" name="typing_system" {{active_value_check(setting('typing_system') ?? 0)}}>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Agora API Configuration Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-camera-video"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Agora API Configuration') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Agora Video Calls Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-agora_video" class="form-label fw-bold mb-0">{{ __('Agora Video Calls') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable Agora to start video chat service in your website.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="chck-agora_video" name="agora_video" {{active_value_check(setting('agora_video') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Agora Configuration Fields -->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label for="agora_app_id" class="form-label fw-bold">{{ __('App ID') }}</label>
                                        <input type="text" id="agora_app_id" name="agora_app_id" class="form-control" value="{{setting('agora_app_id')}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label for="agora_app_certificate" class="form-label fw-bold">{{ __('App Certificate') }}</label>
                                        <input type="text" id="agora_app_certificate" name="agora_app_certificate" class="form-control" value="{{setting('agora_app_certificate')}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label for="agora_customer_id" class="form-label fw-bold">{{ __('Customer ID') }}</label>
                                        <input type="text" id="agora_customer_id" name="agora_customer_id" class="form-control" value="{{setting('agora_customer_id')}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="agora_customer_secret" class="form-label fw-bold">{{ __('Customer Secret') }}</label>
                                        <input type="text" id="agora_customer_secret" name="agora_customer_secret" class="form-control" value="{{setting('agora_customer_secret')}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <p class="text-center">Looking for Live Stream Configuration? <a href="#">Click here</a>.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <!-- Video & Audio Chat Settings Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-camera-video-fill"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Video & Audio Chat Settings') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Video Calls Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-video_calls" class="form-label fw-bold mb-0">{{ __('Video Calls') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable video chat feature for users to make video calls on your site.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="video_calls" name="video_calls" {{active_value_check(setting('video_calls') ?? 0)}}> 
                                </div>
                            </div>

                            <!-- Audio Calls Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-audio_calls" class="form-label fw-bold mb-0">{{ __('Audio Calls') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable audio chat feature for users to make audio calls on your site.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="audio_calls" name="audio_calls" {{active_value_check(setting('audio_calls') ?? 0)}}> 
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Twilio API Configuration Card -->
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-telephone"></i>
                                </div>
                                <h5 class="card-title mb-0">{{ __('Twilio API Configuration') }}</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Twilio Video/Audio Calls Toggle -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-twilio_calls" class="form-label fw-bold mb-0">{{ __('Twilio Video/Audio Calls') }}</label>
                                    <p class="text-muted small mb-0">{{ __('Enable Twilio to start video chat service in your website. Note that enabling Twilio will disable Agora. Twilio supports video and audio calls.') }}</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="twilio_calls" name="twilio_calls" {{active_value_check(setting('twilio_calls') ?? 0)}}> 
                                </div>
                            </div>

                            <!-- Twilio Configuration Fields -->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group mb-3">
                                        <label for="twilio_account_sid" class="form-label fw-bold">{{ __('Account SID') }}</label>
                                        <input type="text" id="twilio_account_sid" name="twilio_account_sid" class="form-control" value="{{setting('twilio_account_sid') ?? ''}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="twilio_api_key" class="form-label fw-bold">{{ __('API Key') }}</label>
                                        <input type="text" id="twilio_api_key" name="twilio_api_key" class="form-control" value="{{setting('twilio_api_key') ?? ''}}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="twilio_api_secret" class="form-label fw-bold">{{ __('API Secret') }}</label>
                                        <input type="text" id="twilio_api_secret" name="twilio_api_secret" class="form-control" value="{{setting('twilio_api_secret') ?? ''}}">
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 text-center">
                                <p class="mb-0">{{ __('Looking for SMS Twilio Configuration?') }} <a href="https://demo.wowonder.com/admin-cp/email-settings">{{ __('Click here') }}</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.update_settings')
@endsection